program linseznam;
uses crt;

{   Program prebere linearni seznam, katerega elementi so cela     }
{   stevila. Podprogram nam ta seznam razdeli na seznam sodih in   }
{   seznam lihih stevil.                                           }
{                                                                  }
{   Napisal :   Vladimir Bensa          }
{   Smer :      Uporabna matematika     }
{   Letnik :    prvi                    }
{   Predmet :   Racunalniski praktikum  }
{   Datum :     18. maj 1992.           }
{               6. april 1997.          }

type kazalec = ^seznam;
     seznam = record
        stevilo : integer;
        naprej  : kazalec
     end;

var zac, lih, sod  : kazalec;        {  zacetki seznama  }
    prazno         : boolean;

procedure branje (var zac : kazalec ; var prazno : boolean);
{                                                               }
{   Podprogram si zapomni linearni seznam z zacetkom pri ZAC.   }
{   Seznam se konca, ce vnesemo prazno besedo.                  }
{                                                               }
var stevilo  : integer;
    s, n, p  : kazalec;
begin
   new (zac);                          {  zacetek seznama  }
   s := zac;                           {  tekoci kazalec  }
   prazno := true;
   n := zac;
   repeat
      readln (stevilo);
      if stevilo <> 0 then begin
         s^.stevilo := stevilo;        {  pomnenje stevila  }
         new (p);                      {  novi kazalec  }
         n := s;                       {  kazalec zadnjega stevila  }
         s^.naprej := p;
         prazno := false;
         s := p                        {  prostor za novo stevilo  }
      end
      else begin
         n^.naprej := nil;            {  popravek na konec  }
         dispose(p)                   {  sprostitev neuporabljenega kazalca  }
      end;
   until stevilo = 0
end;

procedure izpis (var zac : kazalec ; tip : string ;  var prazno : boolean);
{                                                              }
{   Podprogram izpise linearni seznam, ki se zacne pri ZAC .   }
{                                                              }
var p : kazalec;
begin
   if prazno then writeln (tip+' - NIL')
   else begin
      p := zac;                           {  postavitev na zacetek  }
      write (tip+' - ');
      while p <> nil do begin             {  do konca izpisuj stevila  }
         write (p^.stevilo,' - ');
         p := p^.naprej                   {  naslednje stevilo  }
      end;
      writeln ('NIL')
   end
end;

procedure razdeli (var zac , lih , sod : kazalec);
{                                                          }
{   Podprogram razdeli linearni seznam v dva seznama.      }
{                                                          }
var p, l, s, ss, ll, n  : kazalec;
begin
   p := zac;
   new (l);
   lih := l;
   new (s);
   sod := s;
   while p <> nil do begin
      if p^.stevilo mod 2 = 0 then begin
         s^.stevilo := p^.stevilo;
         new (n);                      {  prazno mesto  }
         ss := s;                      {  zadnji element  }
         s^.naprej := n;
         s := n
      end
      else begin
         l^.stevilo := p^.stevilo;
         new (n);                      {  prazno mesto }
         ll := l;                      {  zadnji element  }
         l^.naprej := n;
         l := n
      end;
      p := p^.naprej
   end;
   ss^.naprej := nil;                  {  popravek konca  }
   ll^.naprej := nil
 end;

Begin
   zac := nil;
   lih := nil;
   sod := nil;
   clrscr;
   writeln ('Vpisi stevila v linearni seznam (0 za konec) :');
   writeln;
   branje (zac,prazno);                {  branje linearnega seznama  }
   writeln;
   writeln ('Linearni seznam izgleda takole :');
   writeln;
   izpis (zac,'ZAC',prazno);           {  izpis linearnega seznama  }
   writeln;
   razdeli (zac,lih,sod);              {  razdelitev seznama  }
   writeln;
   writeln ('Razdeljeni linearni seznam :');
   writeln;
   izpis (lih,'LIH',prazno);           {  izpis razdeljenih seznamov  }
   writeln;
   izpis (sod,'SOD',prazno);
   writeln;
   writeln;
   writeln ('Pritisni tipko !');
   repeat until keypressed
End.