program linseznam4;
uses crt;

{   Program prebere dvojno povezani linearni seznam, katerega  }
{   elementi so besede. Podprogram odstrani element iz takega  }
{   seznama.                                                   }
{                                                              }
{   Napisal :   Vladimir Bensa             }
{   Smer :      Uporabna matematika        }
{   Letnik :    prvi                       }
{   Predmet :   Racunalniski praktikum     }
{   Datum :     4. maj 1992.               }
{               6. april 1997.             }

type kazalec = ^seznam;
     seznam = record
        nazaj  : kazalec;
        beseda : string [80];
        naprej : kazalec
     end;

var zac, kon  : kazalec;        {  zacetka seznama  }
    prazno    : boolean;
    mesto     : integer;        {  mesto vriva nove besede  }
    beseda    : string [80];

procedure branje (var zac, kon : kazalec ; var prazno : boolean);
{                                                              }
{   Podprogram si zapomni linearni seznam z zacetkom pri ZAC.  }
{   Seznam se konca pri KON , ko vnesemo prazno besedo.        }
{                                                              }
var beseda   : string [80];
    s, n, p  : kazalec;
begin
   new (zac);                          {  zacetek seznama  }
   s := zac;                           {  tekoci kazalec  }
   prazno := true;
   repeat
      readln (beseda);
      if beseda <> '' then begin
         s^.beseda := beseda;          {  pomnenje besede  }
         new (p);                      {  novi kazalec  }
         if prazno then s^.nazaj := nil
            else s^.nazaj := n;
         s^.naprej := p;
         n := s;                       {  kazalec zadnje besede  }
         prazno := false;
         s := p                        {  prostor za novo besedo  }
      end
      else begin
         n^.naprej := nil;             {  popravek na koncu  }
         kon := n
      end;
   until beseda = ''
end;

procedure izpis (var zac : kazalec ; var prazno : boolean);
{                                                              }
{   Podprogram izpise linearni seznam, ki se zacne pri ZAC .   }
{                                                              }
var p : kazalec;
begin
   if prazno then writeln ('ZAC - NIL')
   else begin
      p := zac;                           {  postavitev na zacetek  }
      write ('ZAC - ');
      while p <> nil do begin             {  do konca izpisuj besede }
         write (p^.beseda,' - ');
         p := p^.naprej                   {  naslednja beseda  }
      end;
      writeln ('NIL')
   end
end;

procedure izpis2 (var kon : kazalec ; var prazno : boolean);
{                                                              }
{   Podprogram izpise linearni seznam, ki se zacne pri KON .   }
{                                                              }
var p : kazalec;
begin
   if prazno then writeln ('KON - NIL')
   else begin
      p := kon;                           {  postavitev na zacetek  }
      write ('KON - ');
      while p <> nil do begin             {  do konca izpisuj besede }
         write (p^.beseda,' - ');
         p := p^.nazaj                    {  naslednja beseda  }
      end;
      writeln ('NIL')
   end
end;

procedure odstrani (var zac, kon : kazalec ; beseda : string);
{                                                              }
{  Podprogram odstrani besedo iz dvojno povezanega seznama.    }
{                                                              }
var p,n,m : kazalec;
begin
   if zac^.beseda = beseda then begin
      zac := zac^.naprej;              {  prva beseda seznama  }
      zac^.nazaj := nil
   end
   else if kon^.beseda = beseda then begin
      kon := kon^.nazaj;               {  zadnja beseda seznama  }
      kon^.naprej := nil
   end
   else begin                          {  vmesna beseda  }
      p := zac;
      while p^.naprej <> nil do begin
         if p^.beseda = beseda then begin
            m := p^.naprej;
            n^.naprej := m;
            m^.nazaj := n
         end;
         n := p;
         p := p^.naprej;
      end
   end
end;

Begin
   clrscr;
   writeln ('Vpisuj besede v linearni seznam :');
   writeln;
   branje (zac,kon,prazno);            {  branje linearnega seznama  }
   writeln;
   writeln ('Linearni seznam izgleda takole :');
   writeln;
   izpis (zac,prazno);                 {  izpis linearnega seznama  }
   izpis2 (kon,prazno);
   writeln;
   write ('Vpi{i odve~no besedo : ');
   readln (beseda);
   odstrani (zac,kon,beseda);          {  odstrani besedo  }
   writeln;
   writeln ('Popravljen seznam :');
   writeln;
   izpis (zac,prazno);                 {  izpis po popravku  }
   izpis2 (kon,prazno);
   writeln;
   writeln ('Pritisni tipko !');
   repeat until keypressed
End.