program linseznam3;
uses crt;

{   Program prebere linearni seznam, katerega elementi so besede.  }
{   S podprogramom ga obrne - mu obrne smer kazalcev.              }
{                                                                  }
{   Napisal :   Vladimir Bensa             }
{   Smer :      Uporabna matematika        }
{   Letnik :    prvi                       }
{   Predmet :   Racunalniski praktikum     }
{   Datum :     4. maj 1992.               }
{               6. april 1997.             }

type kazalec = ^seznam;
     seznam = record
                 beseda : string [80];
                 naprej : kazalec
              end;

var zac     : kazalec;        {  zacetek seznama  }
    prazno  : boolean;
    mesto   : integer;        {  mesto vriva nove besede  }

procedure branje (var zac : kazalec ; var prazno : boolean);
{                                                               }
{   Podprogram si zapomni linearni seznam z zacetkom pri ZAC.   }
{   Seznam se konca, ce vnesemo prazno besedo.                  }
{                                                               }
var beseda   : string [80];
    s, n, p  : kazalec;
begin
   new (zac);                          {  zacetek seznama  }
   s := zac;                           {  tekoci kazalec  }
   prazno := true;
   n := zac;
   repeat
      readln (beseda);
      if beseda <> '' then begin
         s^.beseda := beseda;          {  pomnenje besede  }
         new (p);                      {  novi kazalec  }
         n := s;                       {  kazalec zadnje besede  }
         s^.naprej := p;
         prazno := false;
         s := p                        {  prostor za novo besedo  }
      end
      else begin
         n^.naprej := nil;          {  popravek na konec  }
         dispose(p)                 {  sprostitev neuporabljenega kazalca  }
      end;
   until beseda = ''
end;

procedure izpis (var zac : kazalec ; var prazno : boolean);
{                                                              }
{   Podprogram izpise linearni seznam, ki se zacne pri ZAC .   }
{                                                              }
var p : kazalec;
begin
   if prazno then writeln ('ZAC - NIL')
   else begin
      p := zac;                           {  postavitev na zacetek  }
      write ('ZAC - ');
      while p <> nil do begin             {  do konca izpisuj besede }
         write (p^.beseda,' - ');
         p := p^.naprej                   {  naslednja beseda  }
      end;
      writeln ('NIL')
   end
end;

procedure obrni (var zac : kazalec);
{                                      }
{  Podprogram obrne linearni seznam.   }
{                                      }
var p, n, m : kazalec;
begin
   p := zac;
   n := p^.naprej;
   p^.naprej := nil;
   while n <> nil do begin
      m := n^.naprej;
      n^.naprej := p;
      p := n;
      n := m
   end;
   zac := p
end;

Begin
   clrscr;
   writeln ('Vpisuj besede v linearni seznam :');
   writeln;
   branje (zac,prazno);                {  branje linearnega seznama  }
   writeln;
   writeln ('Linearni seznam izgleda takole :');
   writeln;
   izpis (zac,prazno);                 {  izpis linearnega seznama  }
   writeln;
   obrni (zac);                        {  obrne seznam  }
   writeln;
   writeln ('Obrnjeni seznam :');
   writeln;
   izpis (zac,prazno);                 {  izpis po popravku  }
   writeln;
   writeln ('Pritisni tipko !');
   repeat until keypressed
End.