program linseznam2;
uses crt;

{   Program prebere linearni seznam, katerega elementi so besede.  }
{   S podprogramom pa lahko vstavimo za oziroma pred dano besedo   }
{   novo besedo.                                                   }
{                                                                  }
{   Napisal :   Vladimir Bensa          }
{   Smer :      Uporabna matematika     }
{   Letnik :    prvi                    }
{   Predmet :   Racunalniski praktikum  }
{   Datum :     4. maj 1992.            }
{               6. april 1997.          }

type kazalec = ^seznam;
     seznam = record
        beseda : string [80];
        naprej : kazalec
     end;

var beseda1, beseda2 : string [80];    {  nova, stara beseda  }
    zac              : kazalec;        {  zacetek seznama  }
    prazno           : boolean;
    mesto            : integer;        {  mesto vriva nove besede  }

procedure branje (var zac : kazalec ; var prazno : boolean);
{                                                               }
{   Podprogram si zapomni linearni seznam z zacetkom pri ZAC.   }
{   Seznam se konca, ce vnesemo prazno besedo.                  }
{                                                               }
var beseda : string [80];
    s,n,p  : kazalec;
begin
   new (zac);                          {  zacetek seznama  }
   s := zac;                           {  tekoci kazalec  }
   prazno := true;
   n := zac;
   repeat
      readln (beseda);
      if beseda <> '' then begin
         s^.beseda := beseda;          {  pomnenje besede  }
         new (p);                      {  novi kazalec  }
         n := s;                       {  kazalec zadnje besede  }
         s^.naprej := p;
         prazno := false;
         s := p                        {  prostor za novo besedo  }
      end
      else begin
         n^.naprej := nil;            {  popravek na konec  }
         dispose(p);                  {  sprostimo neuporabljeni kazalec  }
      end;
   until beseda = ''
end;

procedure izpis (var zac : kazalec ; var prazno : boolean);
{                                                              }
{   Podprogram izpise linearni seznam, ki se zacne pri ZAC .   }
{                                                              }
var p : kazalec;
begin
   if prazno then writeln ('ZAC - NIL')
   else begin
      p := zac;                           {  postavitev na zacetek  }
      write ('ZAC - ');
      while p <> nil do begin             {  do konca izpisuj besede }
         write (p^.beseda,' - ');
         p := p^.naprej                   {  naslednja beseda  }
      end;
      writeln ('NIL')
   end
end;

procedure vriv (var zac : kazalec ; nova : string;
                kam : integer ; stara : string);
{                                                              }
{  Podprogram vrine novo besedo pred ali za staro iz seznama.  }
{                                                              }
var prej,n,p : kazalec;
begin
   p := zac;
   while p <> nil do begin
      if p^.beseda = stara then
         case kam of
            1 : begin                  {  vriv pred staro besedo  }
                   new (n);
                   n^.beseda := p^.beseda;
                   n^.naprej := p^.naprej;
                   p^.beseda := nova;
                   p^.naprej := n;
                   p := n
                end;
            2 : begin                  {  vriv za staro besedo  }
                   prej := p^.naprej;
                   new (n);
                   p^.naprej := n;
                   n^.beseda := nova;
                   n^.naprej := prej
                end
      end;
      p := p^.naprej
   end
end;

Begin
   clrscr;
   writeln ('Vpisuj besede v linearni seznam :');
   writeln;
   branje (zac,prazno);                {  branje linearnega seznama  }
   writeln;
   writeln ('Linearni seznam izgleda takole :');
   writeln;
   izpis (zac,prazno);                 {  izpis linearnega seznama  }
   writeln;
   writeln;
   write ('Vpisi novo besedo : ');
   readln (beseda1);
   write ('Vpisi besedo iz seznama : ');
   readln (beseda2);
   repeat
      write ('Vpisi mesto vriva : 1 (pred) ali 2 (za) dano besedo : ');
      readln (mesto)
   until (mesto < 3) and (mesto > 0);
   vriv (zac,beseda1,mesto,beseda2);   {  vrivanje nove besede  }
   writeln;
   writeln ('Popravljeni seznam :');
   writeln;
   izpis (zac,prazno);                 {  izpis po popravku  }
   writeln;
   writeln ('Pritisni tipko !');
   repeat until keypressed
End.