(*                                    *)
(*  Numerina Analiza                 *)
(*  etrta domaa naloga              *)
(*                                    *)
(*  Avtor: Vladimir Bensa             *)
(*  Letnik: 4.                        *)
(*  Smer: Raunalnitvo z matematiko  *)
(*  Datum: 29. avgust 1996.           *)
(*                                    *)

(*  Funkciji Uxx[i, j, h] in Uyy[i, j, h] vrneta pribliek za drugi odvod      *)
(*  v toki (i, j) mree irine h za zgornjo osminko kroga v prvem kvadrantu.  *)

Uxx [0, 0, 1] = -2 U[0, 0, 1] 
Uxx [0, 0, h_] := Uxx[0, 0, h] = 2 * h^(-2) (U[0, 1, h] - U[0, 0, h])
Uxx [0, j_, h_] := Uxx[0, j, h] = 2 * h^(-2) (U[1, j, h] - U[0, j, h])
Uxx [i_, i_, h_] := Uxx[i, i, h] = 2 * h^(-2) (U[i - 1, i, h] - U[i, i, h])
Uxx [i_, j_, h_] := Uxx[i, j, h] = h^(-2) (U[i + 1, j, h] - 2 * U[i, j, h] + U[i - 1, j, h])

Uyy [0, 0, 1] = -2 U[0, 0, 1]
Uyy [i_, i_, h_] := Uyy[i, i, h] = 2 * h^(-2) (U[i, i + 1, h] - U[i, i, h])
Uyy [i_, j_, h_] := Uyy[i, j, h] = h^(-2) (U[i, j + 1, h] - 2 * U[i, j, h] + U[i, j - 1, h])

(*  Funkciji iMax[j, h] in jMax[i, h] vrneta koordinato robne toke mree pri  *)
(*  podani drugi koordinati in irini h . Funkcija iMaxAbs[h] pa za dani h     *)
(*  vrne najvejo mono koordinato v smeri i za zgornjo osminko kroga v prvem  *)
(*  kvadrantu.                                                                 *)

jMax [i_, h_] := jMax[i, h] = Module[{rob = N[Sqrt[h^(-2) - i^2]], tem = N[Round[Sqrt[h^(-2) - i^2]]]},
    If[tem >= rob, Decrement[tem],]; N[tem]]

iMax [j_, h_] := iMax[j, h] = Module[{rob = N[Sqrt[h^(-2) - j^2]], tem = N[Round[Sqrt[h^(-2) - j^2]]]},
    If[tem >= rob, Decrement[tem],]; N[tem]]

iMaxAbs [h_] := Module[{rob = N[1/(h * Sqrt[2])], tem = N[Round[1/(h * Sqrt[2])]]},
    If[tem >= rob, Decrement[tem],]; N[tem]]

(*  Funkcija Sig[i, j, h] vrne razmerje razdalje od robne toke mree do kronice,  *)
(*  glede na velikost mree (torej h), in sicer v smeri j .                         *)

Sig [i_, j_, h_] := N[Sqrt[1 - (i * h)^2] / h - j]

(*  Funkciji RobUxx[i, j, h] in RobUyy[i, j, h] vrneta pribliek za drugi odvod  *)
(*  za toke na robu mree.                                                      *)

RobUxx [0, 0, 1] = Uxx [0, 0, 1]
RobUxx [i_, j_, h_] := Module[{tem = 0, iSig = Sig[j, i, h]},
    If[i == iMax[j, h],
        tem = 2 (iSig * U[i - 1, j, h] - U[i, j, h] * (1 + iSig)) / (h^2 * iSig (iSig + 1)),
        tem = Uxx[i, j, h]];
    tem]

RobUyy [0, 0, 1] = Uyy [0, 0, 1]
RobUyy [j_, j_, h_] := Module[{jSig = Sig[j, j, h]},
    2 (jSig * U[j - 1, j, h] - U[j, j, h] * (1 + jSig)) / (h^2 * jSig (jSig + 1))]
RobUyy [i_, j_, h_] := Module[{tem = 0, jSig = Sig[i, j, h]},
    2 (jSig * U[i, j - 1, h] - U[i, j, h] * (1 + jSig)) / (h^2 * jSig (jSig + 1))]

(*  Funkcija ResiU[h] vrne reitev za U v zgornji osminki kroga v prvem kvadrantu  *)
(*  pri irini mree h .                                                           *)

ResiU [h_] := Module[{Seznam = {}, Spremenljivke = {}, i = 0, j = 0},
    While[i <= iMaxAbs[h],
        j = i;
        While[j < jMax[i, h],
            Seznam = Append[Seznam, Uxx[i, j, h] + Uyy[i, j, h] == 2];
            Spremenljivke = Append[Spremenljivke, U[i, j, h]];
            Increment[j]];
        Seznam = Append[Seznam, RobUxx[i, j, h] + RobUyy[i, j, h] == 2];
        Spremenljivke = Append[Spremenljivke, U[i, j, h]]; 
        Increment[i]];
    Solve[Seznam, Spremenljivke]]

(* *)

NalogaDisk := Module[{k},
    For[k = 0, k < 4, Increment[k], 
        Print["Reitev za h = ", N[2^(-k)], " je: "];
        Print[ResiU[2^(-k)]]]]
