(*                                    *)
(*  Numericna Analiza                 *)
(*  Tretja domaca naloga              *)
(*                                    *)
(*  Avtor: Vladimir Bensa             *)
(*  Letnik: 4.                        *)
(*  Smer: Racunalnistvo z matematiko  *)
(*  Datum: 26. avgust 1996.           *)
(*                                    *)

(*  Zacetni podatek je 200 intervalov na [0, 10] .  *)

H = 1/20

(*  Funkcija Odvod[n] vrne vrednost n-tega odvoda iskane funkcije v tocki 0 za izracun zacetnih  *)
(*  vrednosti po Taylorju.                                                                       *)

Odvod [0] = 1
Odvod [1] = -100 
Odvod [2] = -100 * Odvod[1] + 1
Odvod [n_] := Odvod[n] = -100 * Odvod[n - 1]

(*  Funkcija Taylor[n] vrne n-ti clen Taylorjeve vrste v tocki h za iskano funkcijo.  *)

Taylor [h_, n_] := Taylor[h, n] = 1/n! * Odvod[n] * h^n

(*  Funkcija Vsota[h,n] vrne vsoto Taylorjeve vrste za iskano funkcijo do clena n-te stopnje  *)
(*  v tocki h .                                                                               *)

Vsota [h_, n_] := Vsota[h, n] = Sum[Taylor[h, i], {i, 0, n}]

(*  Funkcija yBash[n] vrne n-to vrednost po Adams-Bashforthovem postopku. Poleg podane zacetne  *)
(*  vrednosti y[0] izracuna prve tri vrednosti po Taylorjevi formuli.                           *)

yBash [0] = 1
yBash [1] = Vsota[H, 50]
yBash [2] = Vsota[2 H, 70]
yBash [3] = Vsota[3 H, 80]
yBash [n_] := yBash[n] = (1 - 1375/6 H) yBash[n-1] + 25/6 H (59 yBash[n-2] - 37 yBash[n-3] + 9 yBash[n-4]) + H^2 / 2 (2n - 1)

(*  Podprogram NalogaBashforth vrne seznam vrednosti v 201 tocki z intervala [0, 10] za  *)
(*  iskano funkcijo po Adams-Bashforthovem postopku.                                     *)

NalogaBashforth := Module[{tem={}},
    Do[tem = Join[tem, {N[yBash[i]]}], {i, 0, 200}]; tem]

(*  Funkcija yMoul[n] vrne n-to vrednost po Adams-Moultonovem postopku. Poleg podane zacetne  *)
(*  vrednosti y[0] izracuna prvi dve vrednosti po Taylorjevi formuli.                         *)

yMoul [0] = 1
yMoul [1] = Vsota[H, 50]
yMoul [2] = Vsota[2 H, 70]
yMoul [n_] := yMoul[n] = ((1 - 475/6 H) yMoul[n-1] + 25/6 H (5 yMoul[n-2] - yMoul[n-3]) + H^2 / 2 (2 n - 1)) / (75/2 H + 1)

(*  Podprogram NalogaMoulton vrne seznam vrednosti v 201 tocki z intervala [0, 10] za  *)
(*  iskano funkcijo po Adams-Moultonovem postopku.                                     *)

NalogaMoulton := Module[{tem = {}},
    Do[tem = Join[tem, {N[yMoul[i]]}], {i, 0, 200}]; tem]

(*  Podprogram NalogaAdams itracuna vrednosti po Adams-Moultonovem postopku prediktor-korektor    *)
(*  po podobnih formulah kot prej. V yAdam[n] je shranjena popravljena vrednost (s korektorjem),  *)
(*  yVmes[n] pa napove prediktor.                                                                 *)

yAdam [0] = 1
yAdam [1] = Vsota[H, 50]
yAdam [2] = Vsota[2 H, 70]
yAdam [3] = Vsota[3 H, 80]

NalogaAdams := Module[{tem = Table[N[yAdam[l]], {l, 0, 3}]},
    Do[yVmes[k] = (1 - 1375/6 H) yAdam[k-1] + 25/6 H (59 yAdam[k-2] - 37 yAdam[k-3] + 9 yAdam[k-4]) + H^2 / 2 (2 k - 1);
        yAdam[k] = (1 - 475/6 H) yAdam[k-1] + 25/6 H (5 yAdam[k-2] - yAdam[k-3]) + H^2 / 2 (2 k - 1) - 75/2 H yVmes[k];
        tem = Join[tem, {N[yAdam[k]]}],
    {k, 4, 200}];
    tem]
