(*                                    *)
(*  Numericna Analiza                 *)
(*  Druga domaca naloga               *)
(*                                    *)
(*  Avtor: Vladimir Bensa             *)
(*  Letnik: 4.                        *)
(*  Smer: Racunalnistvo z matematiko  *)
(*  Datum: 16. avgust 1996.           *)
(*                                    *)

(*  Podprogram NalogaSinus poisce vrednost Si(x) = 0.45 z inverzno interpolacijo.       *)
(*  Spremenljivka P nosi Nevillejevo shemo za integralski sinus v 0.45 in tockah IKS .  *)

NalogaSinus := Module[{},
    P = Table[0, {6}, {6}];  (*  Prazna shema  *)
    Do[P[[i, i]] = (i - 1)/5, {i, 6}];  (*  Zacetni podatki  *)
    IKS = {0, 0.19956, 0.39646, 0.58813, 0.7721, 0.94608};  (*  Zacetne tocke  *)
    P = Napolni;  (*  Dopolnimo shemo  *)
    Print["Priblizki za 0.45 : "];
    While[(NovIKS = SinIntegral[P[[1, 6]]]) != 0.45,  (*  Dokler ne najdemo prave tocke  *)
        Print[N[NovIKS, 10]];  (*  Trenutni priblizek  *)
        Vstavi;  (*  Nova tocka  *)
        P = Napolni];  (*  Dopolnjujemo shemo  *)
    Print[N[NovIKS, 10]];
    Print["Inverz od Si v 0.45 je: ", N[P[[1, 6]], 10]];
    Print["Preskus: SinIntegral[", P[[1, 6]], "] = ", N[SinIntegral[P[[1, 6]]], 10]]]

(*  Funkcija Napolni dopolni Nevillejevo shemo P iz zacetnih vrednosti IKS in       *)
(*  funkcijskih vrednosti P[[i, i]] . Spodnjega trikotnika sheme P ne uporabljamo.  *)
(*  Vrednost P[[1, 6]] je nov priblizek za "integralski arkussinus" od 0.45 .       *)

Napolni := Module[{},
    Do[P[[i, j]] = ((0.45 - IKS[[i]]) * P[[i + 1, j]] - (0.45 - IKS[[j]]) * P[[i, j - 1]]) / (IKS[[j]] - IKS[[i]]),
    {j, 2, 6}, {i, j - 1, 1, -1}];
    P]

(* Podprogram Vstavi[P, IKS, NovIKS] vstavi novo tocko v seznam IKS na ustrezno mesto  *)
(* po velikosti in nov priblizek vrednosti 0.45 v ustrezno mesto v tabelo P . Potem    *)
(* pa se odstrani bolj oddaljeno tocko iz seznama IKS in tudi iz tabele P .            *)

Vstavi := Module[{i = 1},
    While[IKS[[i]] < NovIKS, Increment[i]];
    IKS = Insert[IKS, NovIKS, i];
    P = Insert[P, Join[Table[0, {i - 1}], {P[[1, 6]]}, Table[0, {6 - i}]], i];
    If[NovIKS - IKS[[1]] > IKS[[7]] - NovIKS,
        IKS = Rest[IKS];   (*  Then  *)
        P = Rest[P];
        Do[P[[k]] = RotateLeft[P[[k]]], {k, 1, i - 1}], 
        IKS = Drop[IKS, -1];  (*  Else  *)
        P = Drop[P, -1];
        Do[P[[k]] = RotateRight[P[[k]]], {k, i + 1, 6}]]]
