# Expands a square matrix by repeating each row/column the specified number of times
# mat - A square matrix to be exapanded.
# nn - A vector of number of times each row/column must be repeated. Its length must match the number of rows/columns.
expandMat <- function(mat, nn){
  v <- rep(1:length(nn),nn)
  mat[v,v]
}

# Get an image matrix
# res - The result obtained by kmBlockORPC or similar function.
# clu - The partition.
# imClu - The partition of clusters into modes or levels (should be determined from the res arguemnt)
# FUN - Function used to collaps multiple relations (third matrix dimentsion)
# funImage - Function applied to blocks.
# add - Number added to partition number (usually not used)
# ignore.diag - This is passed to function fun.by.blocks from blockmodeling package
getIM <- function(res, 
                  clu = NULL, 
                  imClu = NULL, 
                  FUN = sum, 
                  funImage = mean,
                  add = 0, 
                  ignore.diag = "default", ...){
  M<-res$M
  if(is.null(M))M<-res
  
  if(length(dim(M))==3){
    M<-apply(res$M,c(1,2),FUN)
  }
  if(is.null(clu)) clu<-clu(res)
  
  k<-res$initial.param$k
  if(is.null(k)) k<-res$kmRes$initial.param$k
  if(is.null(k)) if(is.list(clu))k<-sapply(clu,function(x)length(unique(x)))
  
  if(!is.null(k) & is.null(imClu)){
    nModes<-length(k)
    imClu<-rep(1:nModes, times=k)
  } 
  clu<-unlist(clu)
  if(is.numeric(clu))clu<-clu+add
  IMat<-fun.by.blocks(M,clu=clu,FUN=funImage, na.rm=TRUE,ignore.diag = ignore.diag)
  IMat[is.nan(IMat)]<-0
  return(IMat)
}

# Plot the values of the criterion function for different number of clusters
# data - A data matrix: 1st and 2nd columns are for the number of clusters, 3rd column is for the value of the criterion function ylab T- he y-axis title
# ... - Other parameters of function plot
gridPlotERR <- function(data, ylab = "err", ...){
  red <- order(data[,1], data[,2])
  data <- data[red,]
  plot(1:nrow(data), data[,3], xaxt = "n", xlab = "number of clusters", ylab = ylab, ...)
  axis(1, at = 1:nrow(data),labels = apply(data[, 1:2], 1, function(x) paste(x, collapse = ", ")), las = 2)
  prvi <- unique(data[,1])
  for (i in prvi) {
    xos <- which(data[,1] == i) 
    lines(x = xos, y = data[xos, 3])
  }
  drugi <- unique(data[,2])
  for (i in drugi) {
    xos <- which(data[,2] == i) 
    lines(x = xos, y = data[xos, 3], col = "blue")
  }
}