ex<-expression({
dots <- list(...)
loop.size <- ifelse(is.null(dots$loop.size), 1, dots$loop.size)
loop <- function(x0, y0, cx = x0, cy = y0, color, angle = 0, 
                 label = NA, width = 1, arr = 2, lty = 1, arrow.size = arrow.size, 
                 arr.w = arr.w, lab.x, lab.y, loopSize=loop.size) {
  rad <- angle
  center <- c(cx, cy)
  cp <- matrix(c(x0, y0, x0 + 0.4 * loopSize, y0 + 
                   0.2 * loopSize, x0 + 0.4 * loopSize, y0 - 
                   0.2 * loopSize, x0, y0), ncol = 2, byrow = TRUE)
  phi <- atan2(cp[, 2] - center[2], cp[, 1] - center[1])
  r <- sqrt((cp[, 1] - center[1])^2 + (cp[, 2] - center[2])^2)
  phi <- phi + rad
  cp[, 1] <- cx + r * cos(phi)
  cp[, 2] <- cy + r * sin(phi)
  plot.bezier(cp, 50, color, width, arr = arr, lty = lty, 
              arrow.size = arrow.size, arr.w = arr.w)
  if (is.language(label) || !is.na(label)) {
    lx <- x0 + 0.3
    ly <- y0
    phi <- atan2(ly - center[2], lx - center[1])
    r <- sqrt((lx - center[1])^2 + (ly - center[2])^2)
    phi <- phi + rad
    lx <- cx + r * cos(phi)
    ly <- cy + r * sin(phi)
    if (!is.na(lab.x)) {
      lx <- lab.x
    }
    if (!is.na(lab.y)) {
      ly <- lab.y
    }
    text(lx, ly, label, col = edge.label.color, 
         font = edge.label.font, family = edge.label.family, 
         cex = edge.label.cex)
  }
}})

trace(plot.igraph, at=list(c(73,3,8)),ex )
