rasch.lda.predict <- function (Xtrain, Ytrain, Xtest = NULL, ncomp, nruncv = 0, alpha = 2/3, 
    priors = NULL) 
{
    ntrain <- nrow(Xtrain)
    Ytrain <- as.factor(Ytrain)
    if (is.vector(Xtest)) {
        Xtest <- matrix(Xtest, 1, length(Xtest))
    }
    if (is.null(Xtest)) {
        Xtest <- Xtrain
    }
    if (nruncv == 0 & length(ncomp) > 1) 
        stop("Since length(ncomp)>1, nruncv must be >0")
    if (nruncv > 0) {
        ncomp <- rasch.lda.cv(Xtrain, Ytrain, ncomp = ncomp, nruncv = nruncv, 
            alpha = alpha, priors = priors)
    }

    set.seed(123)
    if(ncomp > 1) {
        lvars.train.kmeans <- kmeans(x = t(Xtrain), centers = ncomp)
        lvars.train.index <- lvars.train.kmeans$cluster
        lvars.test.index <- lvars.train.index
    } else {
        lvars.train.index <- rep(1, ncol(Xtrain))
        lvars.test.index <- rep(1, ncol(Xtest))
    }

    threshold <- my.binarize(Xtrain)$threshold
    
    Xtrain <- binarize(Xtrain, threshold = threshold)
    Xtest <- binarize(Xtest, threshold = threshold)

    scores.train <- matrix(0, nrow(Xtrain), ncomp)
    scores.test <- matrix(0, nrow(Xtest), ncomp)


    if(min(table(lvars.train.index))>1) {


        for(i in 1:ncomp) {
            fit.train <- rasch(Xtrain[,lvars.train.index==i], constraint = cbind(ncol(Xtrain[,lvars.train.index==i]) + 1, 1))
            score.train <- factor.scores(fit.train, resp.patterns = as.matrix(Xtrain[,lvars.train.index==i]))$score.dat$z1
            resp.patterns <- Xtest[,lvars.train.index==i]
            p <- ncol(fit.train$X)

            check.matrix <- matrix(FALSE, nrow=nrow(Xtest[,lvars.test.index==i]), ncol=ncol(Xtest[,lvars.test.index==i]))
            for (j in 1:ncol(fit.train$X)) {
                for (k in 1:nrow(resp.patterns)) {
                    check.matrix[k,j] <- all(unique(resp.patterns[k, j]) %in% c(unique(fit.train$patterns$X[, j]), NA))
                }
            }
            is.na(resp.patterns) <- !check.matrix
        
            score.test <- factor.scores(fit.train, resp.patterns = resp.patterns)$score.dat$z1
            scores.train[,i] <- score.train #create data for Xtrain
            scores.test[,i] <- score.test #create data for Xtrain
        }

        Ztrain <- as.data.frame(scores.train)
        names(Ztrain) <- paste("LV",seq(1:ncomp),sep="")
        Ztrain$y <- Ytrain
   
        Ztest <- as.data.frame(scores.test)
        names(Ztest) <- paste("LV",seq(1:ncomp),sep="")   
    
        if (is.null(priors)) {
            lda.out <- try(lda(formula = y ~ ., data = Ztrain), silent = TRUE)
            if(class(lda.out) == "lda") {
                predclass <- predict(object = lda.out, newdata = Ztest)$class
            } else {
                predclass <- NA
            }
        }
        else {
            lda.out <- lda(formula = y ~ ., data = Ztrain, prior = priors)
        }
        #predclass <- predict(object = lda.out, newdata = Ztest)$class ## Ztest je nereducirana matrika

    } else {
        predclass <- NA
    }    

    return(list(predclass = predclass, ncomp = ncomp))
}
