##########
##########
library(MASS)
library(ltm)
library(biclust)
library(WilcoxCV)
source("./r/rasch.lda.r")
source("./r/rasch.lda.cv.r")
source("./r/rasch.lda.sample.r")
source("./r/my.binarize.r")



load("leukemia.rda")

## prepare my.train matrix
#my.train <- generate.split(niter = 100,n = nrow(lx.original), ntest = nrow(lx.original)/2)
#write.table(my.train,file="my.train.txt",col.names=F,row.names=F,sep='\t')

## prepare random matrices
r50 <- matrix(0, 100, 50)
for (i in 1:100) {
    r50[i, ] <- sample(ncol(lx.original), 50, replace = FALSE)
}
#write.table(r50,file="r50.txt",col.names=F,row.names=F,sep='\t')

r100 <- matrix(0, 100, 100)
for (i in 1:100) {
    r100[i, ] <- sample(ncol(lx.original), 100, replace = FALSE)
}
#write.table(r100,file="r100.txt",col.names=F,row.names=F,sep='\t')

r200 <- matrix(0, 100, 200)
for (i in 1:100) {
    r200[i, ] <- sample(ncol(lx.original), 200, replace = FALSE)
}
#write.table(r200,file="r200.txt",col.names=F,row.names=F,sep='\t')


## start random procedure
my.train <- as.matrix(read.table("my.train.txt",h=F))
r50 <- as.matrix(read.table("r50.txt",h=F))
r100 <- as.matrix(read.table("r100.txt",h=F))
r200 <- as.matrix(read.table("r200.txt",h=F))


# r=50
components.r50 <- NULL
system.time(
for(i in 1:nrow(my.train)) {
    components.r50[i] <- rasch.lda.cv(Xtrain=lx.original[my.train[i,],r50[i,]],Ytrain=ly.original[my.train[i,]],ncomp=1:5,nruncv=ncol(my.train))$ncomp
    cat("Complete: ",i,"\n")
}
)
write.table(components.r50, file="leukemia_rasch_components_r50.txt",col.names=FALSE,row.names=FALSE)


# r=100
components.r100 <- NULL
system.time(
for(i in 1:nrow(my.train)) {
    components.r100[i] <- rasch.lda.cv(Xtrain=lx.original[my.train[i,],r100[i,]],Ytrain=ly.original[my.train[i,]],ncomp=1:5,nruncv=ncol(my.train))$ncomp
    cat("Complete: ",i,"\n")
}
)
write.table(components.r100, file="leukemia_rasch_components_r100.txt",col.names=FALSE,row.names=FALSE)


# r=200
components.r200 <- NULL
system.time(
for(i in 1:nrow(my.train)) {
    components.r200[i] <- rasch.lda.cv(Xtrain=lx.original[my.train[i,],r200[i,]],Ytrain=ly.original[my.train[i,]],ncomp=1:5,nruncv=ncol(my.train))$ncomp
    cat("Complete: ",i,"\n")
}
)
write.table(components.r200, file="leukemia_rasch_components_r200.txt",col.names=FALSE,row.names=FALSE)



## prepare teststat matrices
p50 <- matrix(0, 100, 50)
for(i in 1:nrow(my.train)) {
    teststat <- abs(mt.teststat(t(lx.original[my.train[i,],]), ly.original[my.train[i,]]))
    p50[i,] <- rev(order(teststat))[1:50]
}
write.table(p50,file="p50.txt",col.names=F,row.names=F,sep='\t')

p100 <- matrix(0, 100, 100)
for(i in 1:nrow(my.train)) {
    teststat <- abs(mt.teststat(t(lx.original[my.train[i,],]), ly.original[my.train[i,]]))
    p100[i,] <- rev(order(teststat))[1:100]
}
write.table(p100,file="p100.txt",col.names=F,row.names=F,sep='\t')

p200 <- matrix(0, 100, 200)
for(i in 1:nrow(my.train)) {
    teststat <- abs(mt.teststat(t(lx.original[my.train[i,],]), ly.original[my.train[i,]]))
    p200[i,] <- rev(order(teststat))[1:200]
}
write.table(p200,file="p200.txt",col.names=F,row.names=F,sep='\t')


## start teststat procedure
my.train <- as.matrix(read.table("my.train.txt",h=F))
p50 <- as.matrix(read.table("p50.txt",h=F))
p100 <- as.matrix(read.table("p100.txt",h=F))
p200 <- as.matrix(read.table("p200.txt",h=F))


# p=50
components.p50 <- NULL
system.time(
for(i in 1:nrow(my.train)) {
    components.p50[i] <- rasch.lda.cv(Xtrain=lx.original[my.train[i,],p50[i,]],Ytrain=ly.original[my.train[i,]],ncomp=1:5,nruncv=ncol(my.train))$ncomp
    cat("Complete: ",i,"\n")
}
)
write.table(components.p50, file="leukemia_rasch_components_p50.txt",col.names=FALSE,row.names=FALSE)


# p=100
components.p100 <- NULL
system.time(
for(i in 1:nrow(my.train)) {
    components.p100[i] <- rasch.lda.cv(Xtrain=lx.original[my.train[i,],p100[i,]],Ytrain=ly.original[my.train[i,]],ncomp=1:5,nruncv=ncol(my.train))$ncomp
    cat("Complete: ",i,"\n")
}
)
write.table(components.p100, file="leukemia_rasch_components_p100.txt",col.names=FALSE,row.names=FALSE)


# p=200
components.p200 <- NULL
system.time(
for(i in 1:nrow(my.train)) {
    components.p200[i] <- rasch.lda.cv(Xtrain=lx.original[my.train[i,],p200[i,]],Ytrain=ly.original[my.train[i,]],ncomp=1:5,nruncv=ncol(my.train))$ncomp
    cat("Complete: ",i,"\n")
}
)
write.table(components.p200, file="leukemia_rasch_components_p200.txt",col.names=FALSE,row.names=FALSE)

###################################################################
###################################################################
library(biclust)
source("./r/my.binarize.r")
source("./r/rasch.lda.predict.r")

load("./data/leukemia.rda")
my.train <- as.matrix(read.table("./subsets/my.train.txt",h=F))

r50 <- as.matrix(read.table("./subsets/r50.txt",h=F))
components.r50 <- read.table("./components/leukemia_rasch_components_r50.txt",h=F)$V1

r100 <- as.matrix(read.table("./subsets/r100.txt",h=F))
components.r100 <- read.table("./components/leukemia_rasch_components_r100.txt",h=F)$V1

r200 <- as.matrix(read.table("./subsets/r200.txt",h=F))
components.r200 <- read.table("./components/leukemia_rasch_components_r200.txt",h=F)$V1


error.rate.r50 <- NULL
for(i in 1:nrow(my.train)) {
    predict <- rasch.lda.predict(Xtrain=lx.original[my.train[i,],r50[i,]],Ytrain=ly.original[my.train[i,]],Xtest=lx.original[-(my.train)[i,],r50[i,]],ncomp=components.r50[i])$predclass
    confussion.matrix <- table(predict,ly.original[-(my.train)[i,]])
    error.rate.r50[i] <- (confussion.matrix[1,2]+confussion.matrix[2,1])/sum(confussion.matrix)
    cat("Complete: ",i, "\n")
}
write.table(error.rate.r50, file="leukemia_rasch_errorrate_r50.txt",col.names=FALSE,row.names=FALSE)

error.rate.r100 <- NULL
for(i in 1:nrow(my.train)) {
    predict <- rasch.lda.predict(Xtrain=lx.original[my.train[i,],r100[i,]],Ytrain=ly.original[my.train[i,]],Xtest=lx.original[-(my.train)[i,],r100[i,]],ncomp=components.r100[i])$predclass
    confussion.matrix <- table(predict,ly.original[-(my.train)[i,]])
    error.rate.r100[i] <- (confussion.matrix[1,2]+confussion.matrix[2,1])/sum(confussion.matrix)
    cat("Complete: ",i, "\n")
}
write.table(error.rate.r100, file="leukemia_rasch_errorrate_r100.txt",col.names=FALSE,row.names=FALSE)

error.rate.r200 <- NULL
for(i in 1:nrow(my.train)) {
    predict <- rasch.lda.predict(Xtrain=lx.original[my.train[i,],r200[i,]],Ytrain=ly.original[my.train[i,]],Xtest=lx.original[-(my.train)[i,],r200[i,]],ncomp=components.r200[i])$predclass
    confussion.matrix <- table(predict,ly.original[-(my.train)[i,]])
    error.rate.r200[i] <- (confussion.matrix[1,2]+confussion.matrix[2,1])/sum(confussion.matrix)
    cat("Complete: ",i, "\n")
}
write.table(error.rate.r200, file="leukemia_rasch_errorrate_r200.txt",col.names=FALSE,row.names=FALSE)



p50 <- as.matrix(read.table("./subsets/p50.txt",h=F))
components.p50 <- read.table("./components/leukemia_rasch_components_p50.txt",h=F)$V1

p100 <- as.matrix(read.table("./subsets/p100.txt",h=F))
components.p100 <- read.table("./components/leukemia_rasch_components_p100.txt",h=F)$V1

p200 <- as.matrix(read.table("./subsets/p200.txt",h=F))
components.p200 <- read.table("./components/leukemia_rasch_components_p200.txt",h=F)$V1



error.rate.p50 <- NULL
for(i in 1:nrow(my.train)) {
    predict <- rasch.lda.predict(Xtrain=lx.original[my.train[i,],p50[i,]],Ytrain=ly.original[my.train[i,]],Xtest=lx.original[-(my.train)[i,],p50[i,]],ncomp=components.p50[i])$predclass
    confussion.matrix <- table(predict,ly.original[-(my.train)[i,]])
    error.rate.p50[i] <- (confussion.matrix[1,2]+confussion.matrix[2,1])/sum(confussion.matrix)
    cat("Complete: ",i, "\n")
}
write.table(error.rate.p50, file="leukemia_rasch_errorrate_p50.txt",col.names=FALSE,row.names=FALSE)

error.rate.p100 <- NULL
for(i in 1:nrow(my.train)) {
    predict <- rasch.lda.predict(Xtrain=lx.original[my.train[i,],p100[i,]],Ytrain=ly.original[my.train[i,]],Xtest=lx.original[-(my.train)[i,],p100[i,]],ncomp=components.p100[i])$predclass
    confussion.matrix <- table(predict,ly.original[-(my.train)[i,]])
    error.rate.p100[i] <- (confussion.matrix[1,2]+confussion.matrix[2,1])/sum(confussion.matrix)
    cat("Complete: ",i, "\n")
}
write.table(error.rate.p100, file="leukemia_rasch_errorrate_p100.txt",col.names=FALSE,row.names=FALSE)

error.rate.p200 <- NULL
for(i in 1:nrow(my.train)) {
    predict <- rasch.lda.predict(Xtrain=lx.original[my.train[i,],p200[i,]],Ytrain=ly.original[my.train[i,]],Xtest=lx.original[-(my.train)[i,],p200[i,]],ncomp=components.p200[i])$predclass
    confussion.matrix <- table(predict,ly.original[-(my.train)[i,]])
    error.rate.p200[i] <- (confussion.matrix[1,2]+confussion.matrix[2,1])/sum(confussion.matrix)
    cat("Complete: ",i, "\n")
}
write.table(error.rate.p200, file="leukemia_rasch_errorrate_p200.txt",col.names=FALSE,row.names=FALSE)      



















    






