﻿// Copyright (c) Igor Grešovnik (2008 - present), IGLib license; http://www2.arnes.si/~ljc3m2/igor/iglib/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

using IG.Lib;
using IG.Num;
using IG.Neural;
using IG.Script;

using IG.Crypto;


// REMARKS:
// Preffix "Shared" is here because the file is included in the IGShell's project 
// For easy maintenance of compatibility with libraries

namespace IG.Test
{ 


    /// <summary>Class containing the main method.</summary>
    /// <remarks><para>Follows standard scheme for IGLib-based simple application.</para></remarks>
    /// $A Igor Oct12 Jan13;
    public class ProgramIGShell 
    {
 
        /// <summary>Entry point of the application.</summary>
        /// <param name="AppArguments">Application arguments.</param>
        [STAThread]
        public static void Main(string[] args)
        {

            try
            {
                // Enable visuall styles - e.g. lsuch things that Crtl-A means "Select all".
                System.Windows.Forms.Application.EnableVisualStyles();
            }
            catch { }

            int numArgs = 0;
            if (args != null)
            {
                numArgs = args.Length;
            }
            if (numArgs == 0)
            {
                Console.WriteLine(Environment.NewLine 
                    + "No arguments were specified." + Environment.NewLine + Environment.NewLine
                    + "Run the application by typing: " +  Environment.NewLine 
                    + "  " +  UtilSystem.GetCurrentProcessExecutableName()  + " command <arg1> <arg2> ..." 
                    + "or"
                    + "  " +  UtilSystem.GetCurrentProcessExecutableName()  + " ?" + Environment.NewLine
                    + "for list of commands."
                    + Environment.NewLine + Environment.NewLine
                    + "See the *.cmd files for example commmands." + Environment.NewLine);
                return;
            }



            AppIGShell application = new AppIGShell();
            IgShellApp.Init();
            

            //application.Script_Run(AppArguments);
            application.Run(args);







        } // Main(string[]) 





        /// <summary>Application class for the current application.</summary>
        public class IgShellApp : IG.Lib.App
        {

            public IgShellApp()
                : base("IGLib Shell", 1 /* version */, 6 /* subversion */, "Demo" /* release */)
            {
            }


            protected override void BeforeInitialization()
            {
                base.BeforeInitialization();
                Expires = false;
                AuthorFirstName = "Igor Grešovnik";
                AuthorAddress1 = "Črneče 147";
                AuthorAddress2 = "2370 Dravograd";
                AuthorAddress3 = "Slovenia";
            }

            protected override void AfterInitialization()
            {
                base.AfterInitialization();
                LaunchInitNotice();
                // AddModule(ModuleTest.Get());
            }


            #region global


            /// <summary>Launches initialization notice.</summary>
            public override void LaunchInitNotice()
            {
                int indent = 8;
                int padLeft = 2;
                int padRight = 2;
                int padTop = 0;
                int padBottom = 0;

                Console.WriteLine();
                Console.WriteLine(
                    DecorationFrameDashed(NoticeShort(), indent, padLeft, padRight, padTop, padBottom));
                Console.WriteLine();

                //Console.WriteLine(
                //    DecorationFrameDoubleDashed(
                //    Notice(), indent, padLeft, padRight, padTop, padBottom)
                //    );
                Console.WriteLine();

                // Reporter.ReportWarning(InitNotice());
            }

            /// <summary>Initializes global application data for the current class of application.</summary>
            public static void Init()
            {
                lock (lockGlobal)
                {
                    if (!InitializedGlobal)
                    {
                        IG.Lib.App.InitApp();
                        Global = new IgShellApp();
                    }
                }
            }

            #endregion

        }  // class ExtShellApp







    }  // class Program_Guest_Ferdo


}
