var NAVTREE =
[
  [ "IGLib", "index.html", [
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Properties", "functions_prop.html", "functions_prop" ],
        [ "Events", "functions_evnt.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html",
"d0/d5a/classIG_1_1Num_1_1VectorBase.html#a2f719cfb07d56dfa376e99da2085ec35",
"d0/d5b/classIG_1_1Forms_1_1TimerControl.html#a526fc8ab91052b2390b52b739a0b1c0b",
"d0/d5b/classIG_1_1Forms_1_1TimerControl.html#af91e906f52a4caca46d316801393ba14",
"d0/d73/classIG_1_1Forms_1_1ReporterForms.html#aadb9bd2b94ec562b53c86ff6dbf469c7",
"d0/de4/classIG_1_1Num_1_1SIPrefix.html#a48f9450cd1f1f494abaa5753a8749fa5",
"d1/d12/classIG_1_1Forms_1_1FontEventArgs.html#a570b2cffe7c04eebc6f911a71c27ff1b",
"d1/d53/classJsonPrettyPrinterPlus_1_1JsonPrettyPrinterInternals_1_1JsonPPStrategyContext.html#a96ce787121dae0586e183e4171c31b86",
"d1/d87/classIG_1_1Lib_1_1CommandAdapterSingleThreaded.html#abcdc51e13c3a06205d5de0e25bfc58fb",
"d1/d98/classIG_1_1Num_1_1PhysicalUnit.html#afea3e707de8d7c142c4393632b9b7c74",
"d1/db7/classIG_1_1Gr3d_1_1VtkControlBase.html#a6ad44987d8b2fccfad6d46696becf1e7",
"d1/dec/classIG_1_1Lib_1_1InterfaceInterpreterBase.html#a2b65c25b80ff55ace647d9f5e4f341b4",
"d2/d28/classIG_1_1Forms_1_1DialogControl.html#a1b5dd8c560818fe19bfc0dafa37b2153",
"d2/d3b/classIG_1_1Lib_1_1UtilSystem_1_1MissingAssembly.html#a482ee98da1461409c0ab418373c81b4f",
"d2/d7e/classIG_1_1Script_1_1ScriptGraphics3DBase.html#afb4e90dd97abdafc9decc9a06226c5e6",
"d2/da7/structIG_1_1Num_1_1Experimental_1_1xdouble.html#a0c9c6bf09c9a5d694b64d41e46370de4",
"d3/d02/classIG_1_1Lib_1_1XmlParser.html#a414dddeb757b95e6c76ab8bc72177dd1",
"d3/d40/classIG_1_1Lib_1_1ScriptLoaderBase.html#adb9c8b3e817e37a8d9d4b776ae522633",
"d3/d84/classIG_1_1Num_1_1AnalysisComparer.html#ad0b798827b4f79cc8f587384da5f1e0c",
"d3/dbb/classIG_1_1Num_1_1ParallelJobContainerBase.html#a9352c284227b11c0055175d1b530788b",
"d4/d1d/classIG_1_1Num_1_1Matrix.html#a286b60f7f9e08ff4e33d081977bc8077",
"d4/d34/interfaceIG_1_1Num_1_1IAnalysisResults.html#a0e240c97037cf69c5be719568753b2d5",
"d4/d52/classIG_1_1Num_1_1ScalarFunctionRadialParametric.html#aaf52c60c287736c3941014c2a6877f5c",
"d4/d96/interfaceIG_1_1Forms_1_1IReporterSpeech.html#aca73a0b9e36f56e0ddf678a5d925ed87",
"d4/de2/classIG_1_1Lib_1_1ReporterBase.html#a516430cd409e7bc211a3cc96a3fbcb96",
"d4/df9/MatrixDecompositions_8cs.html#a2d8d652327d287e1dc579577a8302e21",
"d5/d34/classIG_1_1Forms_1_1XMLTreeView.html#a38aa7ab5628145aa5a8ae71802edf2c8",
"d5/d42/classIG_1_1Num_1_1Func_1_1WeightPol3.html#ad4444181b042f2fd49ff1b3089fc1f20",
"d5/d63/classIG_1_1Script_1_1AppBase.html#a0b6dc0fb7286f60f358d61075a726f28",
"d5/db6/classIG_1_1Num_1_1ScalarFunctionResults.html",
"d5/dc3/classIG_1_1Num_1_1VectorFunctionResults.html#ad7d4a4a34834657f55ed3943f2dbcfcd",
"d5/de2/classIG_1_1Num_1_1GridGenerator1dBase.html#a78922f790c87b3d344aa069c34a4b030",
"d6/d0c/classIG_1_1Num_1_1ScalarFunctionExamples_1_1Quadratic2d.html#a269474a7836bf4f2287163a1a64f0b4d",
"d6/d5f/classIG_1_1Num_1_1PointContainer_3_01PointContainerType_00_01PointType_01_4.html#afd6ba59627a59661f824e673e1dea126",
"d6/d7c/classIG_1_1Num_1_1UnstructuredMesh1d_3_01TCoord_00_01TIndexField_00_01TIndex_00_01TScalarField_0888101c843ab001b3ccfb7eab71d580c.html#a71e9954851ed43ded3957d246b283fc4",
"d6/d8a/classIG_1_1Forms_1_1FadingMessageOld.html#a7b54800c2622dfdb2c8b125ad2e53bab",
"d6/dbc/interfaceIG_1_1Lib_1_1Old_1_1IReporter.html#af6d33ebc11b56201ce2d193afe630c9a",
"d7/d04/namespaceIG_1_1ReporterMsgForms.html",
"d7/d5e/classIG_1_1Num_1_1PenaltyEvaluator.html#a8b07b0fd81f91a69023eb9eb8dec9bdd",
"d7/d7f/VectorFunctionScriptControl_8Designer_8cs.html",
"d7/da9/classIG_1_1Forms_1_1InpuOrOutputtDataDefinitionControl.html#a774cae41e3c2373bc9dffbd646d862dd",
"d7/db4/interfaceIG_1_1Num_1_1INeuralApproximator.html#a6dcd91606c84a65e308c74b47a776bc8",
"d7/dca/classIG_1_1Lib_1_1Util.html#ae8b880f900e454ce4e0a97a1d88c50e4",
"d8/d14/classIG_1_1Num_1_1ParallelJobServerBase_3_01JobContainerType_01_4.html#ad849a3289af928cc329a381904a44174",
"d8/d23/classIG_1_1Forms_1_1XMLTreeViewFormOld__Keep__Some__time.html#ad6c1d9add8e0938f0400b602c4a3f79c",
"d8/d56/UtilIdRegistration_8cs.html",
"d8/d6f/classIG_1_1Num_1_1UnstructuredMesh2d_3_01TCoord_00_01TIndexField_00_01TIndex_00_01TScalarField_005be46de0377c8097eefa4c316608a31.html#aaab314aa6f0235b72455de1a16cde4d9",
"d8/d91/classIG_1_1Forms_1_1ConsoleForm.html#a1f3e303c974f39c87a24d1d071db28cc",
"d8/d91/classIG_1_1Forms_1_1ConsoleForm.html#af953abbe1b1f9c45f4f22f29c7798189",
"d8/dfa/classIG_1_1Forms_1_1WindowShiftControlText.html#a9cb24c40d1a1961c2ab7822be835091c",
"d9/d61/classIG_1_1Num_1_1Func_1_1WeightGauss.html#abdf04f42af618240d05eb9811ce14c6d",
"d9/da9/classIG_1_1Lib_1_1UtilSystem.html#a38c89398c8cbe55b111b82ebf2b49d5c",
"d9/db9/classIG_1_1Num_1_1MatrixBase.html#a265b0a52c0d0683c32a1bb157b57440e",
"d9/dcb/classIG_1_1Lib_1_1UtilCsv.html#ac6a45e49b3beeabc50cb7f8cecfa6711",
"d9/def/classIG_1_1Forms_1_1AppTestForms.html#a4769623490906b40570fca43c1def0fc",
"da/d16/classIG_1_1Lib_1_1RealFunctionLoader.html#ab631092756bafa1cc0bcb317dda89d1c",
"da/d4d/IndicatorLightTestForm_8cs.html",
"da/d89/classIG_1_1Num_1_1Matrix2d.html#a715bb706008a0e0ef9a28d8652cff939",
"da/d93/classIG_1_1Num_1_1SampledDataCsv.html#ae6d13186dfdf0799401a3fb16fecbe3c",
"db/d1b/classIG_1_1Num_1_1PointContainer_3_01PointLinkType_00_01PointContainerType_00_01PointType_01_4.html#ad7d272f9e1747743b867a7920716035d",
"db/d98/classIG_1_1Lib_1_1ApplicationCommandlineBase.html#a94cced76a06f41efa40fa2474a07611c",
"db/da4/classIG_1_1Script_1_1ScriptAppBase.html#a55fc00f851ebf3eff4b1aae14474d7c1",
"db/dc7/classIG_1_1Lib_1_1Module.html#ab136bf2e069b004a30a4514b0558533d",
"dc/d0c/classIG_1_1Script_1_1LoadableScriptShellNeuralBase.html#a661d955bdf0eea8822630d575f54749b",
"dc/d28/classIG_1_1Forms_1_1VectorFunctionScriptControl.html#a66ded81ce3a3467a870fe758e4b08709",
"dc/d6c/classIG_1_1Script_1_1ScritpRealFunctionExample.html#a849281a1515cc3f4f4f89ae10b094d27",
"dc/db5/classIG_1_1Num_1_1NeuralApproximatorBase.html#a6fe3cad1102458f4c448960c3999dd76",
"dc/dd2/classIG_1_1Lib_1_1InterfaceInverse.html#a809590e786588ea05d7963491ff2aa40",
"dc/ded/classIG_1_1Num_1_1VectorStore_3_01T_01_4.html#aa2d5735f01a035aa3d041805ce33583a",
"dd/d1b/classIG_1_1Lib_1_1ModuleBase.html#ae98adbefe98af1014c8ed0577a2de444",
"dd/d40/classIG_1_1Crypto_1_1ConstCrypto.html#ac93d042a717c33a6cd8127691c33aa58",
"dd/d7b/interfaceIG_1_1Num_1_1IOptimizationData.html#a74dcb3d98cfb3fcfcde538e669e492a9",
"dd/da5/classIG_1_1Forms_1_1XmlTreeViewControl.html#a5b383aa0f9004ac60e96cf91adc1376a",
"dd/dcf/classIG_1_1Num_1_1BoundingBox2d.html#a18726a38f42692a79d199ceefada5dd9",
"dd/dff/classIG_1_1Gr3d_1_1TestVtkGraphicBase.html#aa20f7beddac7b5bb0a5ed1d1185e9445",
"de/d1e/interfaceIG_1_1Lib_1_1IWaitCondition.html#a7aa51195c5e880e93bfaea4cd00aadda",
"de/d72/classIG_1_1Forms_1_1IndicatorLight.html#adc1b25f2532ea961a41c7708c96661aa",
"de/dac/classIG_1_1Gr3d_1_1VtkPlotBase.html#aa3ddb4b53e1fc46fe63b4abe28467bf3",
"de/dcf/classIG_1_1Lib_1_1CommandLineApplicationInterpreter.html#aae22eade24d8f4d67ad988349fde5bd1",
"de/df1/classIG_1_1Lib_1_1ReporterConsole.html#a48a6399d1f54fb6a5b23fbefc1950e65",
"df/d16/structIG_1_1Num_1_1vec3.html#a5d59efa3cf445d3e5245e37590db420a",
"df/d64/classIG_1_1Num_1_1NeuralTrainingParameters_1_1ComparerBase.html#a6b44cfa133dbb6591f14b444d8b0002f",
"df/db8/classIG_1_1Forms_1_1ReporterConf.html#a4dd97872b6dacdd3ea41e4914153951c",
"df/dee/classIG_1_1Num_1_1SimKosecFileManagerConvBase.html#a8ae33ec96a1291d8e77cfd13a9a0f964",
"functions_vars_n.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function hashValue()
{
  return $(location).attr('hash').substring(1).replace(/[^\w\-]/g,'');
}

function hashUrl()
{
  return '#'+hashValue();
}

function pathName()
{
  return $(location).attr('pathname').replace(/[^-A-Za-z0-9+&@#/%?=~_|!:,.;\(\)]/g, '');
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  }
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  if (node.childrenData) {
    var imgNode = document.createElement("img");
    imgNode.style.paddingLeft=(16*level).toString()+'px';
    imgNode.width  = 16;
    imgNode.height = 22;
    imgNode.border = 0;
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    var span = document.createElement("span");
    span.style.display = 'inline-block';
    span.style.width   = 16*(level+1)+'px';
    span.style.height  = '22px';
    span.innerHTML = '&#160;';
    domNode.appendChild(span);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  var ancParent = $(anchor.parent());
  if (ancParent.hasClass('memItemLeft') ||
      ancParent.hasClass('fieldname') ||
      ancParent.hasClass('fieldtype') ||
      ancParent.is(':header'))
  {
    pos = ancParent.position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath(pathName());
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = hashUrl();
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+hashValue()+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parent().attr('class')=='fieldname'){
    glowEffect(anchor.parent().parent(),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath(pathName())+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).css({'display':'block'});
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function removeToInsertLater(element) {
  var parentNode = element.parentNode;
  var nextSibling = element.nextSibling;
  parentNode.removeChild(element);
  return function() {
    if (nextSibling) {
      parentNode.insertBefore(element, nextSibling);
    } else {
      parentNode.appendChild(element);
    }
  };
}

function getNode(o, po)
{
  var insertFunction = removeToInsertLater(po.li);
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
  insertFunction();
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1].replace(/[^\w\-]/g,'');
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2(pathName())+hashUrl());
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  $(window).load(function(){
    navTo(o,toroot,hashUrl(),relpath);
    showRoot();
  });

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath(pathName())+':'+hashValue();
         a=$('.item a[class$="'+clslink.replace(/</g,'\\3c ')+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2(pathName());
       navTo(o,link,hashUrl(),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,hashUrl(),relpath);
     }
  })
}

