var NAVTREE =
[
  [ "IGLib", "index.html", [
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Properties", "functions_prop.html", "functions_prop" ],
        [ "Events", "functions_evnt.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Typedefs", "globals_type.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html",
"d0/d5a/classIG_1_1Num_1_1VectorBase.html#ab0a0624bdb35f5f3a194059f9a2da4f0",
"d0/d9a/interfaceIG_1_1Lib_1_1IColorScale.html#a911098d81889f9d3f2ae56bdc51aaaba",
"d1/d01/classIG_1_1Lib_1_1StringTable.html#a47c27f9eb8304c0147be598e7e21eec7",
"d1/d50/classIG_1_1Lib_1_1CommandUseReference.html#a48c7aaa87cdf8f91bee3e6de156d1f3a",
"d1/d96/classIG_1_1Forms_1_1FadingMessage.html#a86fde54b3d8918e22018044be04fd2d4",
"d1/d9a/classIG_1_1Num_1_1LinearSolverBase.html#a3a7703abae5afd064d6a258ac8737a88",
"d1/de2/classIG_1_1Lib_1_1UtilStr.html#a9876b69339da596ddd4b4b6ac798d5cf",
"d2/d1b/classIG_1_1Num_1_1ConstMisc.html#a0acf20349a4738fc2ac229fee3ca1ee8",
"d2/d4a/classIG_1_1Forms_1_1Test_1_1ColorConverterForm.html#a7e5d6bbbec35f5daffaf1b6ffda5dba6",
"d2/d8e/interfaceIG_1_1Lib_1_1IReporterTextWriter.html#ada2d6268b0c2f3edf4f2921c219bfdb9",
"d2/dbb/classIG_1_1Num_1_1ScalarFunctionRadialUntransformedOneParametric.html#a9c566dbe2f9cc8123f984f4f9fc0313d",
"d3/d16/classIG_1_1Num_1_1StructuredMeshGeometry3d_3_01TCoord_01_4.html",
"d3/d53/classIG_1_1Lib_1_1NamedPipeClientBase.html#add17bff03f539f75b5301cc057293b40",
"d3/db2/classIG_1_1Num_1_1Func.html#a2ce37dcbad5cbe53294d26f03271745c",
"d4/d1d/classIG_1_1Num_1_1Matrix.html#ace5a32e6e356503ede3777dc99a3719f",
"d4/d34/interfaceIG_1_1Num_1_1IAnalysisResults.html#a89bae15deb6d85a52dfdbcc49e9d6e45",
"d4/d5c/classIG_1_1Num_1_1StructuredMesh2d_3_01TCoord_00_01TIndexField_00_01TIndex_00_01TScalarField_00_49da4d60d4197e2c2afdd8458772851b.html#a95d325cfcbfb456a6e325b9d25b1e006",
"d4/ddf/classIG_1_1Lib_1_1ObjectStore_3_01T_01_4.html#ae7231848370359cf2d4eeb0b2d9238fa",
"d4/de2/classIG_1_1Lib_1_1ReporterBase.html#ac524c81458407963d12b08ade823f1e4",
"d5/d34/classIG_1_1Forms_1_1XMLTreeView.html#a09a96ede8b5e5387fdf46c624571af85",
"d5/d34/classIG_1_1Forms_1_1XMLTreeView.html#abe14e41d2ac3dd995a2a857cd873aa5f",
"d5/d4e/classIG_1_1Num_1_1AnalysisResults.html#ab55c484fb7d44df9a32bc80d1d0932d9",
"d5/d87/classIG_1_1Lib_1_1ColorScale.html#a72d6bd940e414a2098857f7cc2558b08",
"d5/db7/classIG_1_1Num_1_1M.html#ade78261480e86ddcb32613b278c3919c",
"d5/dd9/classIG_1_1Lib_1_1IpcStreamClientServerBase.html#a7e397d9e308e7b3e3d72fe92ce190d4e",
"d6/d16/classIG_1_1Gr_1_1PlotZedGraphBase.html#a1b639cc325550cb75ebac4c0c162ccad",
"d6/d64/classIG_1_1Crypto_1_1CryptoManager.html#a60753088f4f67ccc5991175c9ed878d9",
"d6/d82/classIG_1_1Num_1_1NeuralTrainingLimits.html#aa4734c49f8d01d7880441da1ec8f6029",
"d6/dbe/interfaceIG_1_1Num_1_1IVectorFunctionResults.html#ac15326543c380562c0c3d1c97a96d2d2",
"d7/d21/classIG_1_1Lib_1_1Copy_1_1NamedPipeClientBase.html#a98d0284f9ea796dac57ab0d750578b5f",
"d7/d7e/classIG_1_1Forms_1_1Test_1_1MessageBoxBuilder.html#a01bedc8ff5e4b19efd7115c6af6f8e05",
"d7/db4/classIG_1_1Plot2d_1_1GraphBase.html#ab9da925211e10b6b5cb6109e0db67b9b",
"d7/dca/classIG_1_1Lib_1_1Util.html#ac81e07cc102d3a82736418f191296c7a",
"d8/d14/classIG_1_1Num_1_1ParallelJobServerBase_3_01JobContainerType_01_4.html#adf03ee9f85a27647aec276657b834c08",
"d8/d57/classIG_1_1Num_1_1PointCloud_3_01PointLinkType_00_01PointContainerType_00_01PointType_01_4.html#a2ade0a4b0756122056e4e32c513b2c55",
"d8/d6d/classIG_1_1Forms_1_1HashGeneratorControl.html#aa425ff0fe594d2ca88718b0858aa4f87",
"d8/d91/classIG_1_1Forms_1_1ConsoleForm.html#a335362c2bef5010f1bb11f1def07d06b",
"d8/daa/classXMLTree_1_1Form1.html#ac7b8da1a775b25bc329a8f6cd3e32132",
"d9/d19/classIG_1_1Num_1_1ConstPhysical.html#a065ac01d9da9cbe2c14bdd18e9d9b98a",
"d9/d76/classIG_1_1Lib_1_1LogRecord.html#a01225b747bc45e693c11bbf8283fc4f4",
"d9/da9/classIG_1_1Lib_1_1UtilSystem.html#a99eff4f7700614e5795a1a761a24631a",
"d9/db9/classIG_1_1Num_1_1MatrixBase.html#a931cca49c7fa1380ae01c4795fc2fbd2",
"d9/dcf/classIG_1_1Gr_1_1PlotterZedGraph.html#a93733c7151bbf62362528e847854ba39",
"d9/dfc/classIG_1_1Num_1_1SimKosecFileManagerBase.html#aa1420a3d0b4a1adff435be6666cacb2e",
"da/d2e/classIG_1_1Num_1_1Matrix3d.html#a45b05e1309a191bf4677f77fb148d662",
"da/d67/classIG_1_1Lib_1_1WaitCondition.html#a58886eef1556d0d60cd54361e72527be",
"da/d93/classIG_1_1Num_1_1SampledDataCsv.html#a4a35af29d11d8e5749472d7ae862695c",
"da/df9/classIG_1_1Lib_1_1ReporterConsole__Base.html#a764bbcdda32333aa001d7b089e1eba32",
"db/d84/classIG_1_1Lib_1_1LoadableRealFunctionBase.html#a0075822b96d464f4a07c7aa8b0b7786c",
"db/da4/classIG_1_1Script_1_1ScriptAppBase.html#a232be7e5769a4b9b74e01f5b88304e85",
"db/dc9/UtilCryptoAux_8cs.html#a4014ca3d89234719d13e6c200d7f6969a902b0d55fddef6f8d651fe1035b7d4bd",
"dc/d2a/classIG_1_1Num_1_1TestClass.html#aefeafd8bf187811c93708521e1df9327",
"dc/d89/classIG_1_1Num_1_1NonSIUnit.html#a77a37ff8c4a0900a6d7e68a502b5dc9b",
"dc/dbf/classIG_1_1Num_1_1Func_1_1Cubic.html#a27c4a1f0d1631c3a61dfeb4ae9b5d073",
"dc/de8/classIG_1_1Num_1_1Vector2d.html#a2657ce74cbf28a3b6ed73b0e64286033",
"dd/d1b/classIG_1_1Lib_1_1ModuleBase.html#ad9a1a4c0a3b1bf34c94d55ec73da1441",
"dd/d40/classIG_1_1Crypto_1_1ConstCrypto.html#ae9aee0854ddeaf958db169e2574f40f2",
"dd/d9b/classIG_1_1Gr_1_1PlotZedgraphCurve.html#aac711ebcb2d193534f2d90b4d2c05ce1",
"dd/dec/classIG_1_1Lib_1_1ExpressionEvaluatorCompiled.html#a6f0c9c079eca9c57f7415dd461834e24",
"de/d0d/interfaceIG_1_1Lib_1_1IReporterBase.html#a96a02dc871c38b5d58971284b9576762",
"de/d95/classIG_1_1Num_1_1Func3d2dExamples_1_1Torus.html#ad01bff06d2a3ffc9a0f3affdd6f56724",
"de/dcf/classIG_1_1Lib_1_1CommandLineApplicationInterpreter.html#a12f91bb48ab47ecc543b5253379254cd",
"de/de7/classIG_1_1Lib_1_1StopWatch1.html#a5b4cac3e4958cd82b58bc557ba1ab85e",
"df/d16/structIG_1_1Num_1_1vec3.html#a4308c2540b4b02c6509c73c2dd4304e7",
"df/d64/classIG_1_1Num_1_1NeuralTrainingParameters_1_1ComparerBase.html#a6b44cfa133dbb6591f14b444d8b0002f",
"df/db8/classIG_1_1Forms_1_1ReporterConf.html#a55386621dfa46b949a2f9aa56848538d",
"df/dfd/VtkPlotBase_8cs.html#a6f788691db6e37fbc6c180b514b9f43a"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function hashValue()
{
  return $(location).attr('hash').substring(1).replace(/[^\w\-]/g,'');
}

function hashUrl()
{
  return '#'+hashValue();
}

function pathName()
{
  return $(location).attr('pathname').replace(/[^-A-Za-z0-9+&@#/%?=~_|!:,.;\(\)]/g, '');
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  }
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  if (node.childrenData) {
    var imgNode = document.createElement("img");
    imgNode.style.paddingLeft=(16*level).toString()+'px';
    imgNode.width  = 16;
    imgNode.height = 22;
    imgNode.border = 0;
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    var span = document.createElement("span");
    span.style.display = 'inline-block';
    span.style.width   = 16*(level+1)+'px';
    span.style.height  = '22px';
    span.innerHTML = '&#160;';
    domNode.appendChild(span);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  var ancParent = $(anchor.parent());
  if (ancParent.hasClass('memItemLeft') ||
      ancParent.hasClass('fieldname') ||
      ancParent.hasClass('fieldtype') ||
      ancParent.is(':header'))
  {
    pos = ancParent.position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath(pathName());
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = hashUrl();
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+hashValue()+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parent().attr('class')=='fieldname'){
    glowEffect(anchor.parent().parent(),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath(pathName())+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).css({'display':'block'});
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function removeToInsertLater(element) {
  var parentNode = element.parentNode;
  var nextSibling = element.nextSibling;
  parentNode.removeChild(element);
  return function() {
    if (nextSibling) {
      parentNode.insertBefore(element, nextSibling);
    } else {
      parentNode.appendChild(element);
    }
  };
}

function getNode(o, po)
{
  var insertFunction = removeToInsertLater(po.li);
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
  insertFunction();
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1].replace(/[^\w\-]/g,'');
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2(pathName())+hashUrl());
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  $(window).load(function(){
    navTo(o,toroot,hashUrl(),relpath);
    showRoot();
  });

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath(pathName())+':'+hashValue();
         a=$('.item a[class$="'+clslink.replace(/</g,'\\3c ')+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2(pathName());
       navTo(o,link,hashUrl(),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,hashUrl(),relpath);
     }
  })
}

