var NAVTREE =
[
  [ "IGLib", "index.html", [
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Properties", "functions_prop.html", "functions_prop" ],
        [ "Events", "functions_evnt.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Typedefs", "globals_type.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html",
"d0/d5a/classIG_1_1Num_1_1VectorBase.html#ab0a0624bdb35f5f3a194059f9a2da4f0",
"d0/d9a/interfaceIG_1_1Lib_1_1IColorScale.html#a911098d81889f9d3f2ae56bdc51aaaba",
"d1/d01/classIG_1_1Lib_1_1StringTable.html#a47c27f9eb8304c0147be598e7e21eec7",
"d1/d50/classIG_1_1Lib_1_1CommandUseReference.html#a48c7aaa87cdf8f91bee3e6de156d1f3a",
"d1/d96/classIG_1_1Forms_1_1FadingMessage.html#a86fde54b3d8918e22018044be04fd2d4",
"d1/d9a/classIG_1_1Num_1_1LinearSolverBase.html#a3a7703abae5afd064d6a258ac8737a88",
"d1/de2/classIG_1_1Lib_1_1UtilStr.html#a865625a974eb434385b4882abe5ccb6f",
"d2/d1b/classIG_1_1Num_1_1ConstMisc.html#a1a4adcb7a1f679d982645592a7b3ef39",
"d2/d4a/classIG_1_1Forms_1_1Test_1_1ColorConverterForm.html#a89a4de37a5c00a3806a9ffd4a3ac22df",
"d2/d8e/interfaceIG_1_1Lib_1_1IReporterTextWriter.html#aebbb1bd2f7e21f319f143df7fee0f16f",
"d2/dc2/interfaceIG_1_1Lib_1_1IInterpreterCommandData.html",
"d3/d16/classIG_1_1Num_1_1StructuredMeshGeometry3d_3_01TCoord_01_4.html#a8ef987cdec23ae549e38bf93da957acb",
"d3/d53/classIG_1_1Lib_1_1NamedPipeClientBase.html#aec336dca4ac4d04b191a9b7244f0631b",
"d3/db2/classIG_1_1Num_1_1Func.html#a87ad96a167d461e3c5b45e850c358b86",
"d4/d1d/classIG_1_1Num_1_1Matrix.html#afed5940c7fbd62a514ca7e8126115837",
"d4/d34/interfaceIG_1_1Num_1_1IAnalysisResults.html#aa9cff989baf9e86fa19f0e49ff91ee78",
"d4/d5c/classIG_1_1Num_1_1StructuredMesh2d_3_01TCoord_00_01TIndexField_00_01TIndex_00_01TScalarField_00_49da4d60d4197e2c2afdd8458772851b.html#acdc77f04a07bb7c6b2e71e1c988aea19",
"d4/de2/classIG_1_1Lib_1_1ReporterBase.html#a1301ac8bcdeb7364e5916787730eef76",
"d4/de2/classIG_1_1Lib_1_1ReporterBase.html#ad77a80c1f62a3a10ec4922658b9ab006",
"d5/d34/classIG_1_1Forms_1_1XMLTreeView.html#a1bd666a59405b8513f8e999071f25f6a",
"d5/d34/classIG_1_1Forms_1_1XMLTreeView.html#ad4a764c845f751f35acc5d6ce0bbc53f",
"d5/d4e/classIG_1_1Num_1_1AnalysisResults.html#ad65113d6f1cb722e73acb09d8f362d68",
"d5/da1/classIG_1_1Gr_1_1StructuredSurfaceMesh3D.html#a3f1ccc507418d061e8606d1affa150ec",
"d5/dbc/classIG_1_1Lib_1_1ReporterConsoleMsgboxSpeech.html#ad4f6184c935eceaf75677315d51f2966",
"d5/dd9/classIG_1_1Lib_1_1IpcStreamClientServerBase.html#accb58f99c5079015dc61ba16b9e14fb5",
"d6/d24/classIG_1_1Lib_1_1TrackedThread.html#a052e9448b895f82a9288a7c2d8f55542",
"d6/d7c/classIG_1_1Num_1_1UnstructuredMesh1d_3_01TCoord_00_01TIndexField_00_01TIndex_00_01TScalarField_0888101c843ab001b3ccfb7eab71d580c.html#a76ca7ee5fa4e99d4dd74c9dc603fd7f2",
"d6/db0/structIG_1_1Num_1_1mat3.html#a5a2dc654de50c250cf14a0faa58af1c0",
"d7/d15/classIG_1_1Lib_1_1LoadableScriptBase.html#a7de902c2fe098531386e354eda93183c",
"d7/d7b/classIG_1_1Lib_1_1LoadableScriptBase_1_1StoredScriptSettings.html",
"d7/db4/classIG_1_1Plot2d_1_1GraphBase.html#a755a63163b1b2a84d5d641a18d49f65f",
"d7/ddc/classIG_1_1Num_1_1ScalarFunctionRadialUntransformed.html#a684797c0a1296a7f61f21a29caa52f2d",
"d8/d45/classIG_1_1Gr3d_1_1Graph3dManipulator.html#a2e32b3651d42f02d411b9d8d3ca627af",
"d8/d5a/classIG_1_1Gr3d_1_1UtilVtk.html#ace92748c9e9210c26b08f80289392ee5",
"d8/d6f/classIG_1_1Num_1_1UnstructuredMesh2d_3_01TCoord_00_01TIndexField_00_01TIndex_00_01TScalarField_005be46de0377c8097eefa4c316608a31.html#a6839fa5fd6a8a8968ba6ffdee4fdac0e",
"d8/d91/classIG_1_1Forms_1_1ConsoleForm.html#a732e5072f1e5524d9900d393cb38d554",
"d8/dd9/classIG_1_1Lib_1_1SerializationDtoBase_3_01Type_00_01BaseType_01_4.html#ab01826a9c3f2fef2057c90eba5532546",
"d9/d3e/classIG_1_1Num_1_1Field_3_01TElement_01_4.html#a29748e4d3cf9877755ed2546755fc5f0",
"d9/d9c/classIG_1_1Forms_1_1WindowShiftControlNumeric.html#a6b4bac01b559de1acc5c68d2e10a4cf1",
"d9/db5/classIG_1_1Lib_1_1PipeServerBase.html#a3185f73de2e7b177e5d2e10df4f83b19",
"d9/db9/classIG_1_1Num_1_1MatrixBase.html#aebd0f9b1ac362953adc30b8d0ba54462",
"d9/dd3/classIG_1_1Num_1_1MatrixStore.html#a6f969c0f55f6194b2bc56b29da850b94",
"da/d06/interfaceIG_1_1Num_1_1IVectorFunction.html#ad5a1da4066b463a5c8345adcfbd90bcd",
"da/d3d/classIG_1_1Forms_1_1ReportMsg__Examples.html",
"da/d87/classIG_1_1Lib_1_1CommandLineApplicationInterpreter_1_1InterpreterPipeServer.html#ae26d442d67843a71f2ad8aa322641be5",
"da/d93/classIG_1_1Num_1_1SampledDataCsv.html#ab96609d12f8fd1596c0f997a3e277a02",
"db/d1d/interfaceIG_1_1Lib_1_1IInterpreter_3_01TCommand_00_01TCommandData_01_4.html",
"db/d98/classIG_1_1Lib_1_1ApplicationCommandlineBase.html#ab2cb6974cdf4e45ea23a16fd262b2a26",
"db/da4/classIG_1_1Script_1_1ScriptAppBase.html#a9c82bd963f8d07ea29636ea8d04a29ea",
"dc/d23/classIG_1_1Num_1_1VectorFunctionBaseGeneral.html#a59743bec2ad722a61031cee82ca85177",
"dc/d56/classIG_1_1Num_1_1FieldCollection_3_01TField_00_01TElement_01_4.html#ab6ded12223d6a0027bb3f3a77ab90ef9",
"dc/db5/classIG_1_1Num_1_1NeuralApproximatorBase.html#aa93303ccf816438699f18924f18ad7aa",
"dc/dd7/classJsonPrettyPrinterPlus_1_1JsonPrettyPrinterInternals_1_1JsonPPStrategies_1_1DefaultCharacterStrategy.html#abae9aa3270dc4c03650996d7dbc984fb",
"dd/d1b/classIG_1_1Lib_1_1ModuleBase.html#a541549b604b8487e7146d88920b5ead2",
"dd/d52/structIG_1_1Lib_1_1color.html#a66f9efc4b538daf765ddedf0d275e268",
"dd/d9d/classIG_1_1Forms_1_1Test_1_1IgFormsQickTests.html#a7143f8c03d5c5354e5a6498ab6187a8e",
"dd/dec/classIG_1_1Lib_1_1ExpressionEvaluatorCompiled.html#a33e2af4cf09a5bec40a35697256bb5ee",
"de/d0d/interfaceIG_1_1Lib_1_1IReporterBase.html#a5730430e705037b5159065ddedecf0a5",
"de/d93/classIG_1_1Gr3d_1_1VtkCurvePlot.html#ac6cd630163f048d788832bbd6c9fc662",
"de/dcf/classIG_1_1Lib_1_1CommandLineApplicationInterpreter.html#a069790a1b55fe4fac9b71402cd976a61",
"de/df1/classIG_1_1Lib_1_1ReporterConsole.html#a06b6b0643b51cf832a48ccd2b776ac8d",
"df/d28/classIG_1_1Lib_1_1PipeClientBase.html#a44b63e08dd9b41ad07ff0f3cd36fcbc1",
"df/d72/StringParser0_8cs.html",
"df/db8/classIG_1_1Forms_1_1ReporterConf.html#a8dae2a010b5340facfcaf021501b075b",
"dir_6a3fed60959a360f9dad5b192e618d75.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function hashValue()
{
  return $(location).attr('hash').substring(1).replace(/[^\w\-]/g,'');
}

function hashUrl()
{
  return '#'+hashValue();
}

function pathName()
{
  return $(location).attr('pathname').replace(/[^-A-Za-z0-9+&@#/%?=~_|!:,.;\(\)]/g, '');
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  }
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  if (node.childrenData) {
    var imgNode = document.createElement("img");
    imgNode.style.paddingLeft=(16*level).toString()+'px';
    imgNode.width  = 16;
    imgNode.height = 22;
    imgNode.border = 0;
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    var span = document.createElement("span");
    span.style.display = 'inline-block';
    span.style.width   = 16*(level+1)+'px';
    span.style.height  = '22px';
    span.innerHTML = '&#160;';
    domNode.appendChild(span);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  var ancParent = $(anchor.parent());
  if (ancParent.hasClass('memItemLeft') ||
      ancParent.hasClass('fieldname') ||
      ancParent.hasClass('fieldtype') ||
      ancParent.is(':header'))
  {
    pos = ancParent.position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath(pathName());
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = hashUrl();
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+hashValue()+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parent().attr('class')=='fieldname'){
    glowEffect(anchor.parent().parent(),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath(pathName())+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).css({'display':'block'});
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function removeToInsertLater(element) {
  var parentNode = element.parentNode;
  var nextSibling = element.nextSibling;
  parentNode.removeChild(element);
  return function() {
    if (nextSibling) {
      parentNode.insertBefore(element, nextSibling);
    } else {
      parentNode.appendChild(element);
    }
  };
}

function getNode(o, po)
{
  var insertFunction = removeToInsertLater(po.li);
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
  insertFunction();
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1].replace(/[^\w\-]/g,'');
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2(pathName())+hashUrl());
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  $(window).load(function(){
    navTo(o,toroot,hashUrl(),relpath);
    showRoot();
  });

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath(pathName())+':'+hashValue();
         a=$('.item a[class$="'+clslink.replace(/</g,'\\3c ')+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2(pathName());
       navTo(o,link,hashUrl(),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,hashUrl(),relpath);
     }
  })
}

