﻿// Copyright (c) Igor Grešovnik (2008 - present), IGLib license; http://www2.arnes.si/~ljc3m2/igor/iglib/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

using IG.Lib;
using IG.Num;
using IG.Neural;
using IG.Script;

using IG.Crypto;


// REMARKS:
// Preffix "Shared" is here because the file is included in the IGShell's project 
// For easy maintenance of compatibility with libraries

namespace IG.Test
{ 


    /// <summary>Class containing the main method.</summary>
    /// <remarks><para>Follows standard scheme for IGLib-based simple application.</para></remarks>
    /// $A Igor Oct12 Jan13;
    public class ProgramIGShell 
    {

 
        /// <summary>Entry point of the application.</summary>
        /// <param name="args">Application arguments.</param>
        [STAThread]
        public static void Main(string[] args)
        {

            try
            {
                // Enable visuall styles - e.g. lsuch things that Crtl-A means "Select all".
                System.Windows.Forms.Application.EnableVisualStyles();
            }
            catch { }

            int numArgs = 0;
            if (args != null)
            {
                numArgs = args.Length;
            }
            if (numArgs == 0)
            {
                Console.WriteLine(Environment.NewLine 
                    + "No arguments were specified." + Environment.NewLine + Environment.NewLine
                    + "Run the application by typing: " +  Environment.NewLine 
                    + "  " +  UtilSystem.GetCurrentProcessExecutableName()  + " command <arg1> <arg2> ..." 
                    + "or"
                    + "  " +  UtilSystem.GetCurrentProcessExecutableName()  + " ?" + Environment.NewLine
                    + "for list of commands."
                    + Environment.NewLine + Environment.NewLine
                    + "See the *.cmd files for example commmands." + Environment.NewLine);
                return;
            }

            AppIGShell application = new AppIGShell();
            //application.Script_Run(args);
            application.Run(args);


        } // Main(string[]) 



    }  // class Program_Guest_Ferdo


}
