﻿
// NEKAJ POMOŽNIH STVARI ZA REŠITEV VAJE 3

// POZOR: 
// Pri programiranju ne pozabite v projektu dodati referenc na druge projekte in knjižnice, ki jih
// uporabljate. Vključite tudi ustrezne "using" deklaracije, s katerimi določite imenske prostore
// iz uporavbljenih knjižnic in projektov, iz katerih bo prevajalnik prepoznal imena brez eksplicitne
// navedbe imenskih prostorov.
//
// PRIMER: 
// Če na začetku datoteke vključite stavek "using System;", lahko namesto 
// System.Console.WriteLine("Moj izpis.");
// napišete kar 
// Console.WriteLine("Moj izpis.");
// V obeh primerih mora biti v projekt, v katerem to napišete, referenca na sistemsko knjižnico "System"
// (poglej pod "References" v Solution Explorer-ju).

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace naloga3
{
    class Program
    {
        static void Main(string[] args)
        {

            double
                a = 0,  // spodnja meja intervala
                b = 2.0 * Math.PI;  // zgornja meja intervala
            int n = 20;  // število podintervalov

            double[] tabx = DivideInterval(a, b, n);
            Console.WriteLine("Delitev intervala:");
            WriteTable(tabx);
            // Definicija delegatov, ki predstavljata znano analitično rešitev in njen odvod:
            RealFunction  
                AnalyticalSolution = f,
                AnalyticalSolutionDerivative = derf;
            double[] tabf = null, tabderf = null;
            // Izračunamo analitično rešitev in njen odvod v obeh tabelah:
            tabf = CalculateFunctionValues(tabx, AnalyticalSolution);
            tabderf = CalculateFunctionValues(tabx, AnalyticalSolutionDerivative);
            Console.WriteLine("");
            Console.WriteLine("Vrednosti analitične rešitve v točkah delitve:");
            WriteTable(tabx, tabf);
            Console.WriteLine("Odvodi analitične rešitve v točkah delitve:");
            WriteTable(tabx, tabderf);

            Console.WriteLine();
            Console.WriteLine();
            double[] tabnumder1, tabnumder2;
            // Izračun tabele numeričnih odvodov iz tabele abscis in funkcije:
            tabnumder1 = CalculateFunctionDerivatives(tabx, tabf);
            // Izračun tabele numeričnih odvodov iz tabele abscis in tabele vrednosti:
            tabnumder2 = CalculateFunctionDerivatives(tabx, tabf);
            Console.WriteLine("Numerični odvodi izračunani iz tabele abscis in iz funkcijskega predpisa:");
            WriteTable(tabx, tabnumder1);
            Console.WriteLine("Numerični odvodi izračunani iz tabele abscis in iz tabbele vrednosti funkcije:");
            WriteTable(tabx, tabnumder2);

            


        }


        /// <summary>Delegat, ki predstavlja realno funkcijo realne spremenljivke.</summary>
        /// <param name="x">Argument funkcije.</param>
        /// <returns>Vrednost realne funkcije.</returns>
        public delegate double RealFunction(double x);

        /// <summary>Funkcija f, ki je analitična rešitev diferencialne enačbe iz naloge.</summary>
        public static double f(double x)
        {
            return Math.Exp(x) - Math.Cos(x);
        }

        /// <summary>Odvod funkcije f (rešitve diferencialne enačbe iz naloge)</summary>

        public static double derf(double x)
        {
            return Math.Exp(x) + Math.Sin(x);
        }

        /// <summary>Razdeli interval [a,b] na n enako dolgih podintervalov in vrne tabelo n+1 vozlišč delitve.</summary>
        /// <param name="a">Spodnja meja intervala.</param>
        /// <param name="b">Zgornja meja intervala.</param>
        /// <param name="n">Število podintervalov.</param>
        /// <returns>Tabela vozliščnih točk.</returns>
        public static double[] DivideInterval(double a, double b, int n)
        {
            double h = (b - a) / (double)(n);  // izračunamo dolžino intervala
            double[] tab = new double[n + 1];  // naredimo tabelo, kamor bomo shranili abscise vozliščnih točk
            for (int i = 0; i <= n; ++i)
                tab[i] = a + h * i;  // napolnimo vrednosti tabele
            return tab;

        }

        /// <summary>Izpiše tabelo na konzolo.</summary>
        /// <param name="tab">Tabela, ki se izpiše.</param>
        public static void WriteTable(double[] tab)
        {
            if (tab == null)
                Console.WriteLine("Tabela ni alocirana.");
            else if (tab.Length == 0)
                Console.WriteLine("Tabela ne vsebuje nobenega elementa.");
            else
            {
                Console.WriteLine("Elementi tabele: ");
                int i;
                for (i = 0; i < tab.Length; ++i)
                {
                    Console.WriteLine("  x[" + i.ToString() + "] = " + tab[i].ToString());
                }
            }
        }


        /// <summary>Izpiše tabeli, od katerih prva vsebuje abscise točk, druge pa funkcijske vrednosti v teh točkah, na konzolo.
        /// Pozor: obstaja funkcija z istim imenom, vendar z enim argumentom ("method overloading")!</summary>
        /// <param name="tabx">Tabela abscis.</param>
        /// <param name="taby">Tabela funkcijskih vrednosti v točkah iz prve tabele.</param>
        public static void WriteTable(double[] tabx, double[] taby)
        {
            if (tabx == null && taby == null)
                Console.WriteLine("Tabeli nista pravilno alocirani.");
            else if (tabx.Length != taby.Length)
                Console.WriteLine("Dolžini tabel sta različni (" + tabx.Length.ToString() + " in " + taby.Length.ToString() + ").");
            else if (tabx.Length == 0)
                Console.WriteLine("Tabeli ne vsebujeta nobenega elementa.");
            else
            {
                Console.WriteLine("Elementi tabele: ");
                int i;
                for (i = 0; i < tabx.Length; ++i)
                {
                    Console.WriteLine("Točka " + i.ToString() + ":  f[" + tabx[i].ToString() + "] = " + taby[i].ToString());
                }
            }
        }

        /// <summary>Izračuna vrednosti podane funkcije f v tabeli točk in vrne tabelo izračunanih vrednosti.</summary>
        /// <param name="tabx">Tabela abscis točk, kjer ovrednotimo funkcijo f.</param>
        /// <param name="f">Funkcja, katere vrednosti računamo.</param>
        /// <returns>Tabela izračunanih vrednosti funkcije f.</returns>
        public static double[] CalculateFunctionValues(double[] tabx, RealFunction f)
        {
            if (tabx == null)
                throw new Exception("Tabela abscis ni alocirana.");
            if (tabx.Length == 0)
                throw new Exception("Tabela abscis ne vsebuje nobene vredosti (dolžina je 0).");
            if (f == null)
                throw new Exception("Funkcija, ki naj bi se izračunala, ni podana (ustrezni argument - delegat je null).");
            int i;
            double [] taby = new double[tabx.Length]; // alociramo tabelo funkcijskih vrednosti, ki jo bomo vrnili
            for (i = 0; i < tabx.Length; ++i)
            {
                taby[i] = f(tabx[i]); // priredimo vrednosti elementom tabele; funkcijo kli;emo preko delegata, sintaksa je
                            // enaka kot pri običajnem klicu funkcije
            }
            return taby;  // vrnemo narejeno tabelo.
        }

        /// <summary>Izračuna numerične odvode funkcije f v točkah, ki so v tabeli tabx.
        /// Opomba: metoda deluje tudi pri tabelah, kjer intervali niso ekvidistančni. Morajo pa biti točke urejene po velikosti.</summary>
        /// <param name="tabx">Tabela točk, v katerih računamo odvode.</param>
        /// <param name="f">Funkcija, katere odvode računamo.</param>
        /// <returns>Tabela numeričnih odvodov funkcije v danih točkah.</returns>
        public static double[] CalculateFunctionDerivatives(double[] tabx, RealFunction f)
        {
            if (tabx == null)
                throw new Exception("Tabela abscis ni alocirana.");
            if (tabx.Length == 0)
                throw new Exception("Tabela abscis ne vsebuje nobene vredosti (dolžina je 0).");
            if (f == null)
                throw new Exception("Funkcija, ki naj bi se izračunala, ni podana (ustrezni argument - delegat je null).");
            int i;
            double [] tabderf = new double[tabx.Length]; // alociramo tabelo funkcijskih vrednosti, ki jo bomo vrnili
            for (i = 0; i < tabx.Length - 1; ++i)
            {
                double h = tabx[i + 1] - tabx[i];  // korak v trenutni točki
                tabderf[i] = (f(tabx[i + 1]) - f(tabx[i])) / h;  // približek za odvod
            }
            // V zadnji točki moramo odvod izračunati drugače, ker ni definiran tabx[i + 1] (indeks preko meja tabele):
            double h1  = tabx[tabx.Length-1]-tabx[tabx.Length-2];
            tabderf[tabx.Length - 1] = ( f( tabx[tabx.Length-1] + h1 ) - f( tabx[tabx.Length-1] ))/h1;
            
            return tabderf;  // vrnemo narejeno tabelo.
        }


        /// <summary>Izračuna numerične odvode tabelirane funkcije v točkah, ki so v tabeli tabx, 
        /// in sicer iz vrednosti funkcije, ki so v tabeli taby.</summary>
        /// <param name="tabx">Tabela abscis, v katerih je funkcija tabelirana.</param>
        /// <param name="taby">Tabela vrednosti funkcije v točkah taby.</param>
        /// <returns>Tabela numeričnih odvodov v točkah iz tabx.</returns>
        public static double[] CalculateFunctionDerivatives(double[] tabx, double[] taby)
        {
            if (tabx == null && taby == null)
                throw new Exception("Tabeli nista pravilno alocirani.");
            if (taby.Length!=tabx.Length)

            if (tabx.Length == 0)
                throw new Exception("Tabela abscis ne vsebuje nobene vredosti (dolžina je 0).");
            int i;
            double [] tabderf = new double[tabx.Length]; // alociramo tabelo funkcijskih vrednosti, ki jo bomo vrnili
            for (i = 0; i < tabx.Length - 1; ++i)
            {
                double h = tabx[i + 1]-tabx[i];  // korak v trenutni točki
                tabderf[i] = (taby[i + 1] - taby[i]) / h;  // približek za odvod
            }
            // V zadnji točki tabele tabx približka odvoda ne moremo izračunati na enak način, ker nimamo naslednje vrednosti.
            // V tem primeru vrednost odvoda enostavno prepišemo iz predzadnje točke:
            tabderf[tabx.Length - 1] = tabderf[tabx.Length - 2];
            return tabderf;  // vrnemo narejeno tabelo.
        }


    }  // class Program




}
