﻿#region About
// Course material: C# for numerical methods
// Copyright (c) 2009-2010, Igor Grešovnik
#endregion About


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using test_library;  // Zaradi tega ni potrebno navajati imenskih prostorov, ko se sklicujemo 
                     // na vsebovane razrede.

namespace test_windows
{
    public partial class obrazec : Form
    {
        public obrazec()
        {
            InitializeComponent();
        }

        /// <summary>Zbriše tekstovna polja.</summary>
        private void btnClear_Click(object sender, EventArgs e)
        {
            txtArg.Clear();
            txtSqr.Clear();
            txtTan.Clear();
        }

        /// <summary>Izvede izračun in izpiše rezultate v tekstovna polja.</summary>
        private void btnCalculate_Click(object sender, EventArgs e)
        {
            try
            {
                double val = double.Parse(txtArg.Text);
                txtSqr.Text = Pow.Square(val).ToString();
                txtTan.Text = Functions.Tan(val).ToString(); // (val).ToString();
            }
            catch (Exception ex)
            {
                MessageBox.Show("NAPAKA: " + ex.Message);
            }
        }

        /// <summary>Zapre obrazec, kar povzroči izhod iz programa.</summary>
        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
