﻿#region About
// Course material: C# for numerical methods
// Copyright (c) 2009-2010, Igor Grešovnik
#endregion About


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace test_library
{

    /// <summary>Returns tangens of an argument.</summary>
    public class Functions
    {
        static public double Tan(double x)
        {
            return Math.Sin(x) / Math.Cos(x) ;
        }
    }


    /// <summary> Razred s statičnimi funkcijami za računanje potenc.</summary>
    public class Pow
    {
        /// <summary>Kvadrat x.</summary>
        /// <param name="x">Argument funkcije.</param>
        /// <returns>Vrednost funkcije.</returns>
        static public double Square(double x)
        {
            return x * x;
        }

        /// <summary>Kvadrat x.</summary>
        /// <param name="x">Argument funkcije.</param>
        /// <returns>Vrednost funkcije.</returns>
        static public double Cubic(double x)
        {
            return x * x * x;
        }

        /// <summary>Funcija x^n.</summary>
        /// <param name="x">Argument funkcije.</param>
        /// <param name="n">Potenca.</param>
        /// <returns>x^n</returns>
        static public double Power(double x, int n)
        {
            if (n < 0)
                return 1 / Power(x, -n);
            if (x == 0)
                return 0;
            if (n == 0)
                return 1;
            else
            {
                double result = x, i = 1;
                while (i < n)
                {
                    ++i;
                    result *= x;  // isto kot result = result*x
                }
                return result;
            }
        }
    }


}
