﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharp
{


    /// <summary>Definition of some extension methods.</summary>
    public static class ExtensionMethods
    {

        /// <summary>Returns string representation of the specified generic list.
        /// Extension method for IList(T).</summary>
        /// <param name="lst">List to be converted to string.</param>
        /// <returns>String representation of the list.</returns>
        public static string ElementsToString <T>(this IEnumerable<T> lst)
        {
            StringBuilder sb = new StringBuilder();
            foreach (T element in lst)
                sb.AppendLine("  " + element.ToString());
            return sb.ToString();
        }

        /// <summary>Returns string representation of the specified generic dictionary.
        /// Extension method for List(double).</summary>
        /// <param name="lst">Dictionary to be converted to string.</param>
        /// <returns>String representation of the dictionary.</returns>
        public static string ElementsToString <TKey, TValue>(this IDictionary<TKey, TValue> table)
        {
            StringBuilder sb = new StringBuilder();
            foreach (KeyValuePair<TKey, TValue> element in table)
                sb.AppendLine("  " + element.Key.ToString() + ": " + element.Value.ToString());
            return sb.ToString();
        }

    } // class ExtensionMethods


    /// <summary>String comparer that sorts in the reverse order.</summary>
    public class StringBackwardComparer : IComparer<string>
    {
        int IComparer<string>.Compare(string x, string y)
        {
            if (x == null)
            {
                if (y == null)
                    return 0;
                else return 1;
            }
            else if (y == null)
                return -1;
            else
            {
                // Returns the opposite value as the default comparer:
                return -x.CompareTo(y);
            }
        }
    }

    

    /// <summary>Examples for using generic container classes.</summary>
    public class ExampleGenericCollections
    {


        /// <summary>Example of how to use generic lists.</summary>
        public static void ExampleList()
        {
            Console.WriteLine();
            Console.WriteLine("List sorting example: ");
            Console.WriteLine();
            
            
            List<string> list = new List<string>();
            
            // Add some strings to the list:
            list.Add("XX");
            list.Add("string 1");
            list.Add("xx");
            list.Add("string 1");

            // Write list contents:
            Console.WriteLine();
            Console.WriteLine("Original list: ");
            Console.WriteLine(list.ElementsToString());

            // Sort the list by using the defaule comparer (string.CompareTo()) method:
            list.Sort();
            Console.WriteLine();
            Console.WriteLine("List after sorting with default comparer: ");
            Console.WriteLine(list.ElementsToString());

            // Sort the list by using custom comparer that sorts in the reverse order: 
            list.Sort(new StringBackwardComparer());
            Console.WriteLine();
            Console.WriteLine("List after sorting with custom comparer that reverses the normal order: ");
            Console.WriteLine(list.ElementsToString());


        }  // class ExampleGenericCollections


        /// <summary>Exaple of how to use generic dictionaries (which contain key-value pairs).</summary>
        public static void ExampleDictionary()
        {
            Console.WriteLine();
            Console.WriteLine("Dictionary example: ");
            Console.WriteLine();

            Dictionary<int, double> elementTable = new Dictionary<int, double>();
            
            // Add some elements to the dictionary:
            elementTable.Add(9, 365.9);
            elementTable.Add(1, 12.1);
            elementTable.Add(5, 424.5);
            elementTable.Add(2, 789.2);
            elementTable.Add(3, 45.3);
            elementTable.Add(4, 424.5); // Values can be repeated, but keyd must be unique.

            // Write dictionary contents:
            Console.WriteLine();
            Console.WriteLine("Original dictionary: ");
            Console.WriteLine(elementTable.ElementsToString());

            // Get and print all keys contained in the dictionary:
            Dictionary<int, double>.KeyCollection keys = elementTable.Keys;
            Console.WriteLine("Keys contained in the dictionary: ");
            Console.WriteLine(keys.ElementsToString());

            // Get and print all keys contained in the dictionary:
            Dictionary<int, double>.ValueCollection values = elementTable.Values;
            Console.WriteLine("Values contained in the dictionary: ");
            Console.WriteLine(values.ElementsToString());
            
            // Change some values in the dictionary: 
            elementTable[1] = 43.1111;
            elementTable[3] = 524.3333;
            elementTable[23] = 32.23;  // When setting value with index operator, the key does not need to exist!!
            Console.WriteLine();
            Console.WriteLine("Dictionary after change of some values: ");
            Console.WriteLine(elementTable.ElementsToString());

            // Check whether the dictionary contains specific keys:
            Console.WriteLine();
            if (elementTable.ContainsKey(2))
                Console.WriteLine("Dictionary contains the key 2.");
            else
                Console.WriteLine("Dictionary does not contain the key 2.");
            if (elementTable.ContainsKey(12))
                Console.WriteLine("Dictionary contains the key 12.");
            else
                Console.WriteLine("Dictionary does not contain the key 12.");

            // Check whether the dictionary contains specific values (this is an expensive operation, avoid it!):
            Console.WriteLine();
            if (elementTable.ContainsValue(43.1111))
                Console.WriteLine("Dictionary contains value 43.1111.");
            else
                Console.WriteLine("Dictionary does not contain value 43.1111.");
            if (elementTable.ContainsValue(2.13))
                Console.WriteLine("Dictionary contains value 2.13.");
            else
                Console.WriteLine("Dictionary does not contain value 2.13.");

            // Remove specific keys and print the dictionary:
            elementTable.Remove(9);
            elementTable.Remove(121);  // you can perform remove operation on key that is not contained in the dictionary
            elementTable.Remove(342);
            elementTable.Remove(3);
            Console.WriteLine();
            Console.WriteLine("Dictionary after removal of some elements: ");
            Console.WriteLine(elementTable.ElementsToString());
        } // ExampleDictionary()


        /// <summary>Exaple of how to use generic dictionaries (which contain key-value pairs).</summary>
        public static void ExampleSortedDictionary()
        {
            Console.WriteLine();
            Console.WriteLine("SORTED dictionary example: ");
            Console.WriteLine();

            SortedDictionary<int, double> elementTable = new SortedDictionary<int, double>();
            
            // Add some elements to the dictionary:
            elementTable.Add(9, 365.9);
            elementTable.Add(1, 12.1);
            elementTable.Add(5, 424.5);
            elementTable.Add(2, 789.2);
            elementTable.Add(3, 45.3);
            elementTable.Add(4, 424.5); // Values can be repeated, but keyd must be unique.

            // Write dictionary contents:
            Console.WriteLine();
            Console.WriteLine("Original dictionary: ");
            Console.WriteLine(elementTable.ElementsToString());

            // Get and print all keys contained in the dictionary:
            SortedDictionary<int, double>.KeyCollection keys = elementTable.Keys;
            Console.WriteLine("Keys contained in the dictionary: ");
            Console.WriteLine(keys.ElementsToString());

            // Get and print all keys contained in the dictionary:
            SortedDictionary<int, double>.ValueCollection values = elementTable.Values;
            Console.WriteLine("Values contained in the dictionary: ");
            Console.WriteLine(values.ElementsToString());
            
            // Change some values in the dictionary: 
            elementTable[1] = 43.1111;
            elementTable[3] = 524.3333;
            elementTable[23] = 32.23;  // When setting value with index operator, the key does not need to exist!!
            Console.WriteLine();
            Console.WriteLine("Dictionary after change of some values: ");
            Console.WriteLine(elementTable.ElementsToString());

            // Check whether the dictionary contains specific keys:
            Console.WriteLine();
            if (elementTable.ContainsKey(2))
                Console.WriteLine("Dictionary contains the key 2.");
            else
                Console.WriteLine("Dictionary does not contain the key 2.");
            if (elementTable.ContainsKey(12))
                Console.WriteLine("Dictionary contains the key 12.");
            else
                Console.WriteLine("Dictionary does not contain the key 12.");

            // Check whether the dictionary contains specific values (this is an expensive operation, avoid it!):
            Console.WriteLine();
            if (elementTable.ContainsValue(43.1111))
                Console.WriteLine("Dictionary contains value 43.1111.");
            else
                Console.WriteLine("Dictionary does not contain value 43.1111.");
            if (elementTable.ContainsValue(2.13))
                Console.WriteLine("Dictionary contains value 2.13.");
            else
                Console.WriteLine("Dictionary does not contain value 2.13.");

            // Remove specific keys and print the dictionary:
            elementTable.Remove(9);
            elementTable.Remove(121);  // you can perform remove operation on key that is not contained in the dictionary
            elementTable.Remove(342);
            elementTable.Remove(3);
            Console.WriteLine();
            Console.WriteLine("Dictionary after removal of some elements: ");
            Console.WriteLine(elementTable.ElementsToString());
        } // ExampleDictionary()


    }






}
