﻿#region About
// Course material: C# for numerical methods
// Copyright (c) 2009-2010, Igor Grešovnik
#endregion About


// FUNCTION ARGUMENTS (CALL BY VALUE AND BY REFERENCE)


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharp
{

    /// <summary>Boxed integer (an integer wrapped to a class).</summary>
    public class BoxedInt
    {

        private BoxedInt()
        {  }

        /// <summary>Constructor.</summary>
        /// <param name="val">Value of the boxed integer.</param>
        public BoxedInt(int value)
        {
            this.Value = value;
        }

        /// <summary>Value of the boxed double.</summary>
        public int Value;

        public override string ToString()
        {
            return Value.ToString();
        }

    }  // class BoxedDouble


    /// <summary>Examples of different function argument specifications.</summary>
    public class ExampleFunctionArguments
    {

        /// <summary>Increments a BoxedInt object.</summary>
        /// <param name="ib">BoxedInt object to be incremented.</param>
        public static void IncrementBoxedInt(BoxedInt iv)
        {
            ++iv.Value;
        }

        /// <summary>Calling an increment function with reference type argument.</summary>
        public static void ReferenceType()
        {
            BoxedInt bi = new BoxedInt(5);
            Console.WriteLine();
            Console.WriteLine("Calling increment function with reference type (BoxedInt object): ");
            Console.WriteLine("Value before calling increment function: " + bi);
            IncrementBoxedInt(bi);
            Console.WriteLine("Value after calling increment function: " + bi
                + Environment.NewLine);
            // bi has actually been incremented because it is of a reference type BoxedInt.
        }

        /// <summary>Increments an integer number.</summary>
        /// <param name="i">Integer to be incremented.</param>
        public static void IncrementInt(int i)
        {
            ++i;
        }

        /// <summary>Calling an increment function with value type argument.</summary>
        public static void ValueType()
        {
            int i = 5;
            Console.WriteLine();
            Console.WriteLine("Calling increment function with value type (int): ");
            Console.WriteLine("Value before calling increment function: " + i);
            IncrementInt(i);
            Console.WriteLine("Value after calling increment function: " + i
                + Environment.NewLine);
            // i has NOT been incremented because it is of value type (int).
        }

        /// <summary>Increments an integer number passed by reference.</summary>
        /// <param name="i">Integer to be incremented.</param>
        public static void IncrementIntRef(ref int i)
        {
            ++i;
        }

        /// <summary>Calling an increment function with value type argument passed by reference.</summary>
        public static void ValueTypeByReference()
        {
            int i = 5;
            Console.WriteLine();
            Console.WriteLine("Calling increment function with value type (int) passed by reference: ");
            Console.WriteLine("Value before calling increment function: " + i);
            IncrementIntRef(ref i);
            Console.WriteLine("Value after calling increment function: " + i
                + Environment.NewLine);
            // i has been incremented; it is of value type (int) but passed by reference.
        }

        /// <summary>Increments an integer number passed by reference (as out).</summary>
        /// <param name="i">Integer to be incremented.</param>
        public static void IncrementIntOut(int i, out int j)
        {
            j=i;
            ++j;
        }

        /// <summary>Calling an increment function with value type argument passed by reference.</summary>
        public static void ValueTypeOut()
        {
            int i = 5;
            Console.WriteLine();
            Console.WriteLine("Calling increment function with value type (int) passed as out: ");
            Console.WriteLine("Value before calling increment function: " + i);
            IncrementIntOut(i, out i);
            Console.WriteLine("Value after calling increment function: " + i
                + Environment.NewLine);
            // i has been incremented; it is of value type (int) but passed as output parameter.
        }

        /// <summary>Runs different examples of the increment function calls.</summary>
        public static void Example()
        {
            ReferenceType();
            ValueType();
            ValueTypeByReference();
            ValueTypeOut();
        }

    }


}
