﻿#region About
// Course material: C# for numerical methods
// Copyright (c) 2009-2010, Igor Grešovnik
#endregion About


// PRIMERI MATRIČNIH OPERACIJ Z Math.Net Iridium
// Pozor: Pred uporabo je potrebno postaviti referenco na projekt Math.Net Iridium!

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// Imensk prostori iz Math.Net Iridium:
using MathNet.Numerics.LinearAlgebra;
using MathNet.Numerics;

using NumLib;


namespace LinAlg
{
    public class ProgramLinAlg
    {
        static void Main(string[] args)
        {
            if (args != null) if (args.Length > 0)
                {
                    try { TestQR(int.Parse(args[0])); return; }
                    catch (Exception ex) { Console.WriteLine("ERROR: " + ex.Message); }
                }

            Console.WriteLine("Matrix tests.");

            // TestMatrixProduct();

            // TestLU();

            //TestQR();

            TestComputationalTimesLU();

            TestComputationalTimesQR();

        }


        /// <summary>Množenje matrik.</summary>
        public static void TestMatrixProduct()
        {
            Console.WriteLine("Test: produkt dveh matrik");
            
            double[,] dA = new double[3, 4] {
                    {10, -61, -8, -29},
                    {95, 11, -49, -47},
                    {40, -81, 91, 68}
                    };
            Matrix A = Matrix.Create(dA);

            Matrix B = Matrix.Create(
                new double[4, 2] {
                    {72, 37},
                    {-23, 87},
                    {44, 29},
                    {98, -23}
                    });
            Matrix C = Matrix.Create(
                new double[3, 2] {
                    {-1071, -4502},
                    { -175, 4132},
                    {15411, -4492}
                    });

            // Izračunamo produkt matrik A in B:
            Matrix P = A.Multiply(B);

            Console.WriteLine();
            Console.WriteLine("Matrika A: " + Environment.NewLine + A.ToString());

            Console.WriteLine();
            Console.WriteLine("Matrika B: " + Environment.NewLine + B.ToString());

            Console.WriteLine();
            Console.WriteLine("Produkt P: " + Environment.NewLine + P.ToString());

            Console.WriteLine();
            Console.WriteLine("Matrika C: " + Environment.NewLine + C.ToString());

            Console.WriteLine();
            Console.WriteLine("P-C: " + Environment.NewLine + (P-C).ToString());
            
        }


        /// <summary>Demonstracija razcepa LU.</summary>
        static void TestLU()
        {
            Console.WriteLine();
            Console.WriteLine("Test LU dekompozicije:");
            Console.WriteLine();

            int n = 3;
            Matrix A = Matrix.Random(n,n);  // naredimo kvadratno matriko z naključnimi elementi
            A[0, 0] = 0.0;  // Element [1,1] postavimo na 0, da bo zagotovo izvedeno pivotiranje (zamenjava vrstic)
            LUDecomposition LU = A.LUDecomposition;  // Izračun LU dekompozicije

            Matrix P = LU.L * LU.U;  // Produkt spodnje in zgornje trikotne matrike:
            Matrix APerm = A.GetMatrix(LU.Pivot, 0, n - 1);

            Console.WriteLine();
            Console.WriteLine("Matrika A: " + Environment.NewLine + A.ToString());

            Console.WriteLine();
            Console.WriteLine("Permutirana matrika APerm: " + Environment.NewLine + APerm.ToString());

            Console.WriteLine();
            Console.WriteLine("Produkt L*U: " + Environment.NewLine + P.ToString());

            Console.WriteLine();
            Console.WriteLine("APerm - L*U: " + Environment.NewLine + (APerm-P).ToString());
           
            // Rešitev enačbe z LU dekompozicijo:

            Matrix b = Matrix.Random(n, 1);
            Matrix x = LU.Solve(b);

            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("Reševanje sistema enačb z LU dekompozicjo:");
            Console.WriteLine();
            Console.WriteLine("Desne strani: " + Environment.NewLine + b.ToString());
            Console.WriteLine();
            Console.WriteLine("Rešitev: " + Environment.NewLine + x.ToString());
            Console.WriteLine();
            Console.WriteLine("Razlika Ax-b: " + Environment.NewLine + (A*x - b).ToString());
            Console.WriteLine();
            Console.WriteLine("Norma razlike: " + (A*x - b).NormF().ToString());
        }  // TestLU()
            

        /// <summary>Demonstracija razcepa QR.</summary>
        static void TestQR()
        {
            Console.WriteLine();
            Console.WriteLine("Test QR dekompozicije:");
            Console.WriteLine();

            int n = 3;
            Matrix A = Matrix.Random(n, n);  // naredimo kvadratno matriko z naključnimi elementi
            QRDecomposition QR = A.QRDecomposition; // Izračunamo QR dekompozicijo matrike A
            Matrix Q = QR.Q; 
            Matrix R = QR.R; 

            Console.WriteLine();
            Console.WriteLine("Matrika A: " + Environment.NewLine + A.ToString());
            Console.WriteLine();
            Console.WriteLine("Ortogonalna matrika Q: " + Environment.NewLine + Q.ToString());
            Console.WriteLine();
            Console.WriteLine("Ortogonalna matrika R: " + Environment.NewLine + R.ToString());
            Console.WriteLine();
            Console.WriteLine("Q*R: " + Environment.NewLine + (Q*R).ToString());
            Console.WriteLine();
            Console.WriteLine("Razlika Q*R - A: " + Environment.NewLine + (Q*R-A).ToString());
            Console.WriteLine();


            // Rešitev enačbe s QR dekompozicijo:

            Matrix b = Matrix.Random(n, 1);
            Matrix x = QR.Solve(b);

            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("Reševanje sistema enačb s QR dekompozicjo:");
            Console.WriteLine();
            Console.WriteLine("Desne strani: " + Environment.NewLine + b.ToString());
            Console.WriteLine();
            Console.WriteLine("Rešitev: " + Environment.NewLine + x.ToString());
            Console.WriteLine();
            Console.WriteLine("Razlika Ax-b: " + Environment.NewLine + (A * x - b).ToString());
            Console.WriteLine();
            Console.WriteLine("Norma razlike: " + (A * x - b).NormF().ToString());

            Console.WriteLine(); Console.WriteLine();
            Console.WriteLine("Norma matrike A: " + A.NormF().ToString());

        }  // TestQR()


        /// <summary>Demonstracija LU dekompozicije.</summary>
        static void TestComputationalTimesLU()
        {
            Console.WriteLine();
            Console.WriteLine("Merjenje časovne zahtevnosti LU dekompozicije:");
            Console.WriteLine();

            int n = 5;

            // Naredimo štoparico, s katero merimo čas. V konstruktorju z argumentom podamo ime, po katerem
            // lahko identificiramo narejeno štoparico. To pride prav, če jih imamo več.
            Timer t = new Timer("Razcep LU");
            // Naredimo še eno štoparico, ki meri čisti čas računanja brez preizkusov:
            Timer tbare = new Timer("Razcep LU, čisti čas");

            for (int i = 1; i <= 3; ++i)
            {
                Console.Write(Environment.NewLine+Environment.NewLine);
                Console.WriteLine("========================================================================");
                Console.WriteLine("Reševanje sistema " + n.ToString() + " enačb z razcepom LU: " + Environment.NewLine);


                t.Start();  // sprožimo štoparico
                // Tvorimo naključen sistem enačb:
                Matrix A = Matrix.Random(n, n);  // naredimo kvadratno matriko z naključnimi elementi
                A[0, 0] = 0.0;  // Element [1,1] postavimo na 0, da bo zagotovo izvedeno pivotiranje (zamenjava vrstic)
                Matrix b = Matrix.Random(n, 1);
                t.Stop();  // ustavimo štoparico
                Console.WriteLine();
                Console.WriteLine("Čas potreben za izdelavo matrike sistema in desnih strani:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                t.Start();  // ponovno sprožimo štoparico za merjenja časa računanja razcepa
                tbare.Start();
                LUDecomposition LU = A.LUDecomposition;  // Izračun LU dekompozicije
                t.Stop();  // ustavimo štoparico
                tbare.Stop();
                Console.WriteLine();
                Console.WriteLine("Čas potreben za računanje LU razcepa:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                t.Start();
                Matrix APerm = A.GetMatrix(LU.Pivot, 0, n - 1);  // Permutirana matrika A
                Matrix P = LU.L * LU.U;  // Produkt spodnje in zgornje trikotne matrike:
                double NormProductDifference = (APerm - P).NormF();
                t.Stop();
                Console.WriteLine();
                Console.WriteLine("Napaka razcepa: norma razlike ||Δ A|| = " + NormProductDifference.ToString());
                Console.WriteLine();
                Console.WriteLine("Čas potreben za preverjanje razcepa:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();


                // Rešitev enačbe z razcepljeno matriko (zamenjava):
                t.Start();
                tbare.Start();
                Matrix x = LU.Solve(b);
                t.Stop();
                tbare.Stop();
                Console.WriteLine();
                Console.WriteLine("Čas potreben za rešitev sistema enačb z razcepljeno matriko:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                // 
                t.Start();
                double NormResiduum = (A * x - b).NormF();
                t.Stop();
                Console.WriteLine();
                Console.WriteLine("Napaka rešitve sistema: norma razlike ||A x - b|| = " + NormResiduum.ToString());
                Console.WriteLine();
                Console.WriteLine("Čas potreben za izračun napake rešitve:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                Console.WriteLine();
                Console.WriteLine("Skupen čas potreben za vse operacije:");
                Console.WriteLine("    t = " + t.TotalTime + " s (CPU: " + t.TotalCpuTime + " s)");
                Console.WriteLine();


                Console.WriteLine();
                Console.WriteLine("Podatki štoparice:");
                Console.WriteLine(t.ToString());
                Console.WriteLine();
                Console.WriteLine("Štoparica, ki meri čisti čas računanja (brez preiskusov):");
                Console.WriteLine(tbare.ToString());
                Console.WriteLine("____________________________________________________________");

                Console.WriteLine(Environment.NewLine);

                // Na koncu resetiramo štoparico in povečamo dimenzijo problema:
                t.Reset();
                n *= 10;

            }
        }  // TestComputationalTimesLU()

        /// <summary>Demonstracija QR dekompozicije.</summary>
        static void TestComputationalTimesQR()
        {
            Console.WriteLine();
            Console.WriteLine("Merjenje časovne zahtevnosti LU dekompozicije:");
            Console.WriteLine();

            int n = 5;

            // Naredimo štoparico, s katero merimo čas. V konstruktorju z argumentom podamo ime, po katerem
            // lahko identificiramo narejeno štoparico. To pride prav, če jih imamo več.
            Timer t = new Timer("Razcep QR");
            // Naredimo še eno štoparico, ki meri čisti čas računanja brez preizkusov:
            Timer tbare = new Timer("Razcep QR, čisti čas");

            for (int i = 1; i <= 3; ++i)
            {
                Console.Write(Environment.NewLine + Environment.NewLine);
                Console.WriteLine("========================================================================");
                Console.WriteLine("Reševanje sistema " + n.ToString() + " enačb z razcepom QR: " + Environment.NewLine);


                t.Start();  // sprožimo štoparico
                // Tvorimo naključen sistem enačb:
                Matrix A = Matrix.Random(n, n);  // naredimo kvadratno matriko z naključnimi elementi
                A[0, 0] = 0.0;  // Element [1,1] postavimo na 0, da bo zagotovo izvedeno pivotiranje (zamenjava vrstic)
                Matrix b = Matrix.Random(n, 1);
                t.Stop();  // ustavimo štoparico
                Console.WriteLine();
                Console.WriteLine("Čas potreben za izdelavo matrike sistema in desnih strani:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                t.Start();  // ponovno sprožimo štoparico za merjenja časa računanja razcepa
                tbare.Start();
                QRDecomposition QR = A.QRDecomposition;  // Izračun QR dekompozicije
                t.Stop();  // ustavimo štoparico
                tbare.Stop();
                Console.WriteLine();
                Console.WriteLine("Čas potreben za računanje QR razcepa:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                t.Start();
                Matrix P = QR.Q * QR.R;  // Produkt spodnje in zgornje trikotne matrike:
                double NormProductDifference = (A - P).NormF();
                t.Stop();
                Console.WriteLine();
                Console.WriteLine("Napaka razcepa: norma razlike ||Δ A|| = " + NormProductDifference.ToString());
                Console.WriteLine();
                Console.WriteLine("Čas potreben za preverjanje razcepa:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();


                // Rešitev enačbe z razcepljeno matriko (zamenjava):
                t.Start();
                tbare.Start();
                Matrix x = QR.Solve(b);
                t.Stop();
                tbare.Stop();
                Console.WriteLine();
                Console.WriteLine("Čas potreben za rešitev sistema enačb z razcepljeno matriko:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                // 
                t.Start();
                double NormResiduum = (A * x - b).NormF();
                t.Stop();
                Console.WriteLine();
                Console.WriteLine("Napaka rešitve sistema: norma razlike ||A x - b|| = " + NormResiduum.ToString());
                Console.WriteLine();
                Console.WriteLine("Čas potreben za izračun napake rešitve:");
                Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
                Console.WriteLine();

                Console.WriteLine();
                Console.WriteLine("Skupen čas potreben za vse operacije:");
                Console.WriteLine("    t = " + t.TotalTime + " s (CPU: " + t.TotalCpuTime + " s)");
                Console.WriteLine();


                Console.WriteLine();
                Console.WriteLine("Podatki štoparice:");
                Console.WriteLine(t.ToString());
                Console.WriteLine();
                Console.WriteLine("Štoparica, ki meri čisti čas računanja (brez preiskusov):");
                Console.WriteLine(tbare.ToString());
                Console.WriteLine("____________________________________________________________");

                Console.WriteLine(Environment.NewLine);

                // Na koncu resetiramo štoparico in povečamo dimenzijo problema:
                t.Reset();
                n *= 10;

            }
        }  // TestComputationalTimesQR()


        /// <summary>Test QR dekompozicije z dano dimenzijo.</summary>
        /// <param name="dimension">Dimenzija matrike sistema enačb, katere razcep iščemo.</param>
        static void TestQR(int dimension)
        {
            if (dimension < 1)
            {
                Console.WriteLine(Environment.NewLine);
                Console.Write("Insert dimension of matrix for QR decomposition: ");
                string input = Console.ReadLine();
                dimension = int.Parse(input);
                Console.WriteLine();
            }
            // Naredimo štoparico, s katero merimo čas. V konstruktorju z argumentom podamo ime, po katerem
            // lahko identificiramo narejeno štoparico. To pride prav, če jih imamo več.
            Timer t = new Timer("Razcep QR");
            // Naredimo še eno štoparico, ki meri čisti čas računanja brez preizkusov:
            Timer tbare = new Timer("Razcep QR, čisti čas");

            Console.Write(Environment.NewLine + Environment.NewLine);
            Console.WriteLine("========================================================================");
            Console.WriteLine("Reševanje sistema " + dimension.ToString() + " enačb z razcepom QR: " + Environment.NewLine);

            t.Start();  // sprožimo štoparico
            // Tvorimo naključen sistem enačb:
            Matrix A = Matrix.Random(dimension, dimension);  // naredimo kvadratno matriko z naključnimi elementi
            A[0, 0] = 0.0;  // Element [1,1] postavimo na 0, da bo zagotovo izvedeno pivotiranje (zamenjava vrstic)
            Matrix b = Matrix.Random(dimension, 1);
            t.Stop();  // ustavimo štoparico
            Console.WriteLine();
            Console.WriteLine("Čas potreben za izdelavo matrike sistema in desnih strani:");
            Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
            Console.WriteLine();

            t.Start();  // ponovno sprožimo štoparico za merjenja časa računanja razcepa
            tbare.Start();
            QRDecomposition QR = A.QRDecomposition;  // Izračun QR dekompozicije
            t.Stop();  // ustavimo štoparico
            tbare.Stop();
            Console.WriteLine();
            Console.WriteLine("Čas potreben za računanje QR razcepa:");
            Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
            Console.WriteLine();

            t.Start();
            Matrix P = QR.Q * QR.R;  // Produkt spodnje in zgornje trikotne matrike:
            double NormProductDifference = (A - P).NormF();
            t.Stop();
            Console.WriteLine();
            Console.WriteLine("Napaka razcepa: norma razlike ||Δ A|| = " + NormProductDifference.ToString());
            Console.WriteLine();
            Console.WriteLine("Čas potreben za preverjanje razcepa:");
            Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
            Console.WriteLine();


            // Rešitev enačbe z razcepljeno matriko (zamenjava):
            t.Start();
            tbare.Start();
            Matrix x = QR.Solve(b);
            t.Stop();
            tbare.Stop();
            Console.WriteLine();
            Console.WriteLine("Čas potreben za rešitev sistema enačb z razcepljeno matriko:");
            Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
            Console.WriteLine();

            // 
            t.Start();
            double NormResiduum = (A * x - b).NormF();
            t.Stop();
            Console.WriteLine();
            Console.WriteLine("Napaka rešitve sistema: norma razlike ||A x - b|| = " + NormResiduum.ToString());
            Console.WriteLine();
            Console.WriteLine("Čas potreben za izračun napake rešitve:");
            Console.WriteLine("    t = " + t.Time + " s (CPU: " + t.CpuTime + " s)");
            Console.WriteLine();

            Console.WriteLine();
            Console.WriteLine("Skupen čas potreben za vse operacije:");
            Console.WriteLine("    t = " + t.TotalTime + " s (CPU: " + t.TotalCpuTime + " s)");
            Console.WriteLine();


            Console.WriteLine();
            Console.WriteLine("Podatki štoparice:");
            Console.WriteLine(t.ToString());
            Console.WriteLine();
            Console.WriteLine("Štoparica, ki meri čisti čas računanja (brez preiskusov):");
            Console.WriteLine(tbare.ToString());
            Console.WriteLine("____________________________________________________________");

            Console.WriteLine(Environment.NewLine);

            // Na koncu resetiramo štoparico in povečamo dimenzijo problema:
            t.Reset();

        }


    }  // class ProgramLinAlg

}
