﻿#region About
// Course material: C# for numerical methods
// Copyright (c) 2009-2010, Igor Grešovnik
#endregion About


// Ta primer prikazuje uporabo metod za numerično integriranje funkcij ene spremenlivke.

// V projektu smo morali dodati referenco na projekt 01integration, ki vsebuje definicije
// metod, ki jih bomo uporabljali.
// V kodi spodaj smo potem dodali še 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using NumLib;

namespace Test
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                // Definicija funkcije in mej intervala:
                RealFunction f = Math.Sin;
                double a = 0, b = Math.PI / 2.0,
                    exact = 1.0;
                // Računanje numeričnega integrala z vedno večjo gostoto točk:
                Console.WriteLine();
                Console.WriteLine("Funkcija: sin(x)");
                Console.WriteLine("Meje integrala: od " + a.ToString() + " do " + b.ToString());
                Console.WriteLine("Natančna vrednost integrala je 1.");
                Console.WriteLine();
                Console.WriteLine("Računanje integrala z vedno večjo gostoto točk:");
                // Integracija s pravokotniškim pravilom in z različnimi števili intervalov.
                int
                    n = 1,  // število podintervalov
                    growthfactor = 4,  // faktor povečanja števila intervalov v vsaki iteraciji
                    numit = 12;  // število iteracij, v katerih povečujemo število podintervalov
                for (int i = 1; i <= numit; ++i)
                {
                    // Izračun integrala z danim številom podintervalov
                    double
                        intRect = Integration.IntegralRectangle(f, a, b, n),
                        intRectLow = Integration.IntegralRectangleLow(f, a, b, n),
                        intRectHigh = Integration.IntegralRectangleHigh(f, a, b, n),
                        intTrap = Integration.IntegralTrapezoidal(f, a, b, n);


                    // Izpis rezultata:
                    Console.WriteLine();
                    Console.WriteLine("Število podintervalov: " + n.ToString());
                    Console.WriteLine("Izračunan integral po različnih metodah:");
                    Console.WriteLine("P.P., spodnja meja:    " + intRectLow.ToString()
                        + ", napaka: " + (intRectLow - exact).ToString());
                    Console.WriteLine("P.P., zgornja meja:    " + intRectHigh.ToString()
                        + ", napaka: " + (intRectHigh - exact).ToString());
                    Console.WriteLine("Pravokotniško pravilo: " + intRect.ToString()
                        + ", napaka: " + (intRect - exact).ToString());
                    Console.WriteLine("Trapezno pravilo:      " + intTrap.ToString()
                        + ", napaka: " + (intTrap - exact).ToString());
                    Console.WriteLine();
                    n = n * growthfactor;  // ali n*=growthfactor;
                }

            //    // Primerjava treh različic metod:
            //    Console.WriteLine();
            //    Console.WriteLine();
            //    Console.Write("Nadaljuj z naslednjim testom (0/1)? ");
            //    string odg = Console.ReadLine();
            //    if (int.Parse(odg) != 0)
            //    {
            //        Console.WriteLine("Računanje integrala z različnimi metodami:");
            //    }

            }
            catch (Exception ex)
            {
                Console.WriteLine();
                Console.WriteLine("NAPAKA: " + ex.Message);
                Console.WriteLine();
            }
        }
    }
}
