﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NumLib.Classes
{
    public class SparseMatrix : Matrix
    {

        private List<SortedDictionary<int, double>> _components;

        public SparseMatrix(int d1, int d2)
        {
            this._dim1 = d1;
            this._dim2 = d2;

            _components = new List<SortedDictionary<int, double>>(d1);

            for (int i = 0; i < d1; i++)
            {
                _components.Add(new SortedDictionary<int, double>());
            }
        }

        public override double this[int i, int j]
        {
            get
            {
                SortedDictionary<int, double> row;

                if (i < 0 || i >= this.Dimension1)
                {
                    throw new IndexOutOfRangeException("First index out of range.");
                }
                if (j < 0 || j >= this.Dimension2)
                {
                    throw new IndexOutOfRangeException("Second index out of range.");
                }
                row = _components[i];
                if (row.ContainsKey(j))
                {
                    return row[j];
                }
                else
                {
                    return 0.0;
                }
            }

            set
            {
                SortedDictionary<int, double> row;

                row = _components[i];
                row[j] = value;
            }
        }

        new public static void Example()
        {
            int d1 = 3;
            int d2 = 3;
            SparseMatrix A = new SparseMatrix(d1, d2);
            SparseMatrix B = new SparseMatrix(d1, d2);
            SparseMatrix R = new SparseMatrix(d1, d2);

            A[0,0] = 1.1;
            A[1,1] = 2.5;
            A[2,2] = 5.3;
            A[0,2] = 4.7;

            B[0,0] = 1.1;
            B[1,1] = 2.5;
            B[2,2] = 5.3;

            Console.WriteLine("Matrix A:");
            Console.WriteLine(A);
            Console.WriteLine("Matrix B:");
            Console.WriteLine(B);
            A.Add(B);
            Console.WriteLine("Result A+B:");
            Console.WriteLine(A);

        }
    }
}
