﻿#region About
// Course material: C# for numerical methods
// Copyright (c) 2009-2010, Igor Grešovnik
#endregion About


// BASIC DEFINITIONS (DELEGATES, etc.)

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


namespace NumLib
{
    /// <summary>This delegate represents a real-valued function of one variable.</summary>
    /// <param name="x">Function argument.</param>
    /// <returns>Function value.</returns>
    public delegate double RealFunction(double x);


    /// <summary>This delegate represents a real-valued function of several variable.</summary>
    /// <param name="x">Array of variables.</param>
    /// <returns>Function value.</returns>
    public delegate double ScalarFunction(double[] x);


    /// <summary>This delegate represents a vector-valued function of several variable.</summary>
    /// <param name="x">Array of variables.</param>
    /// <returns>Function values (as array of doubles, i.e. type double[]).</returns>
    public delegate double [] VectorFunction(double[] x);

}
