#!/usr/bin/perl -w

###########################################################################################
# Izpis asa in uporaba dveh podprogramov:						      #
# izraun zaporednega dneva v letu in izraun dneva in meseca iz zaporedneva dneva v letu #
###########################################################################################

#==============================================================================
#podprogram za izraun julijanskega (zaporednega) dneva: VHOD -> dan, mesec, leto; IZHOD -> zaporedni dan

sub julidan {
	my ($dan, $mesec, $leto) = @_; #deklariramo vhodne spremenljivke 

	# jdan zaetnih dni v mesecu (neprestopna leta)
	my %zac_jdan = (
        	'1' => '1',
        	'2' => '32',
        	'3' => '60',
        	'4' => '91',
        	'5' => '121',
        	'6' => '152',
        	'7' => '182',
        	'8' => '213',
        	'9' => '244',
        	'10' => '274',
        	'11' => '305',
        	'12' => '335',
	);

	
	$julidan = $dan + $zac_jdan{$mesec} - 1;

	# e je leto prestopno
	if($leto % 4 == 0 && $mesec >= 3) {
		$julidan++;
	}
	return $julidan; # izhodna vrednost
}

#===================================================================================
# podprogram za izraun meseca in dneva iz jdan: VHOD: -> zaporedni dan, leto; IZHOD -> dan, mesec

sub dm_jdan {
	my ($jdan, $leto) = @_;
	
	my %zac_jdan = (
                '1' => '1',
                '2' => '32',
                '3' => '60',
                '4' => '91',
                '5' => '121',
                '6' => '152',
                '7' => '182',
                '8' => '213',
                '9' => '244',
                '10' => '274',
                '11' => '305',
                '12' => '335',
		'13' => '366', # "nadomestek" za januar
        );

	# za prestopna leta
	my %zac_jdan_p = (
		'1' => '1',
                '2' => '32',
                '3' => '61',
                '4' => '92',
                '5' => '122',
                '6' => '153',
                '7' => '183',
                '8' => '214',
                '9' => '245',
                '10' => '275',
                '11' => '306',
                '12' => '336',
                '13' => '367', # "nadomestek" za januar
       	);

	if($leto % 4 != 0) {
		for($i = 1; $i <= 12; $i++) {
			if($jdan >= $zac_jdan{$i} && $jdan < $zac_jdan{$i+1}) {
				$mesec = $i;
			}
		}
		$dan = $jdan - $zac_jdan{$mesec} + 1;
	}
	else { # za prestopna leta
		for($i = 1; $i <= 12; $i++) {
		        if($jdan >= $zac_jdan_p{$i} && $jdan < $zac_jdan_p{$i+1}) {
                                $mesec = $i;
                        }
                }
                $dan = $jdan - $zac_jdan_p{$mesec} + 1;
	}
	@dm = ($dan, $mesec);
	return @dm; # izhod je v obliki niz (dan, mesec)
}

#=======================================================================================
# zaporedni dan v letu za izbran datum
print "Vtipkaj dan, mesec in leto (DD MM LLLL): ";
$vhod = <STDIN>;
chomp($vhod);

@cas = split(" ", $vhod);
printf "Dan %d.%d.%d je %d. v izbranem letu.\n", $cas[0], $cas[1], $cas[2], julidan($cas[0], $cas[1], $cas[2]);

# kateri dan bo ez 100 dni?
$jdan2 = $julidan + 100;
if(($jdan2 > 365 && $cas[2] % 4 != 0) || ($jdan2 > 366 && $cas[2] % 4 == 0)) {
	$jdan2 -= 100;
	$cas[2]++; 
}
$leto2 = $cas[2];

($dan, $mesec) = dm_jdan($jdan2, $leto2);
print "ez 100 dni bo $dan.$mesec.$leto2\n";

($sek, $min, $ura, $dan, $mesec, $leto, my $tdan, my $jdan, my $isdst) = localtime();
if($min < 10) {
	$min = "0".$min;
}
if($sek < 10) {
	$sek = "0".$sek;
}
$mesec++;
$leto += 1900;
print "Program se je izvedel ob $ura:$min:$sek UTC, dne $dan.$mesec.$leto.\n";

