/*
 * An applet class to display an LC model.
 *
 * Adapted from the ThreeD.java JDK example.
 * Kevin Thomas, June 20, 1996.
 * Cray Research, Inc.
 */

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Event;
import java.io.InputStream;
import java.net.URL;

/** An applet to put a 3D model into a page */
public class lcViewer extends Applet implements Runnable {
    lcModel md;
    boolean painted = true;
    float xfac;
    int prevx, prevy;
    int xoff = 0, yoff = 0;
    float xtheta, ytheta;
    float scalefudge = 1;
    Matrix3D amat = new Matrix3D(), tmat = new Matrix3D();
    String mdname = null;
    String message = null;

    public void init() {
	System.out.println("at init time, CM = "+getColorModel());
	mdname = getParameter("model");
	try {
	    scalefudge = Float.valueOf(getParameter("scale")).floatValue();
	}catch(Exception e){};
	amat.yrot(20);
	amat.xrot(20);
	if (mdname == null)
	    mdname = "model.obj";
	resize(size().width <= 20 ? 400 : size().width,
	       size().height <= 20 ? 400 : size().height);
    }
    public void run() {
	InputStream is = null;
	try {
	    Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
	    is = new URL(getDocumentBase(), mdname).openStream();
	    lcModel m = new lcModel (is);
	    md = m;
	    m.findBB();
	    float xw = m.xmax - m.xmin;
	    float yw = m.ymax - m.ymin;
	    float zw = m.zmax - m.zmin;
	    if (yw > xw)
		xw = yw;
	    if (zw > xw)
		xw = zw;
	    float f1 = size().width / xw;
	    float f2 = size().height / xw;
	    xfac = 0.7f * (f1 < f2 ? f1 : f2) * scalefudge;
	} catch(Exception e) {
	    md = null;
	    message = e.toString();
	}
	try {
	    if (is != null)
		is.close();
	} catch(Exception e) {
	}
	repaint();
    }
    public void start() {
	if (md == null && message == null)
	    new Thread(this).start();
    }
    public void stop() {
    }
    public boolean mouseDown(Event e, int x, int y) {
	prevx = x;
	prevy = y;
	return true;
    }
    public boolean mouseDrag(Event e, int x, int y) {
	if ((e.modifiers & e.ALT_MASK) != 0) {
		// middle button - zoom
		tmat.unit();
		float factor = 1.0f;
		if (prevy > y) {
			// zoom out
			float dist = (float) (prevy - y);
			float ratio = dist / size().height;
//			System.out.println("zoom out distance "+dist);
			factor =  10.0f * ratio + 1.0f;
			factor =  1.0f / factor; // zoom out
		} else if (prevy < y) {
			// zoom in
			float dist = (float) (y - prevy);
			float ratio = dist / size().height;
//			System.out.println("zoom in distance "+dist);
			factor = 10.0f * ratio + 1.0f;
		}
//		System.out.println("zoom factor "+factor);
		tmat.scale(factor);
		amat.mult(tmat);
	} else if ((e.modifiers & e.META_MASK) != 0) {
		// right button - pan
		xoff = xoff + x - prevx;
		yoff = yoff + y - prevy;
	} else {
		// left button - rotate
		tmat.unit();
		float xtheta = (prevy - y) * 360.0f / size().width;
		float ytheta = (x - prevx) * 360.0f / size().height;
		tmat.xrot(xtheta);
		tmat.yrot(ytheta);
		amat.mult(tmat);
	}
	if (painted) {
	    painted = false;
	    repaint();
	}
	prevx = x;
	prevy = y;
	return true;
    }
    public void paint(Graphics g) {
	//System.out.println("at paint time, CM = "+getColorModel());
	if (md != null) {
	    md.mat.unit();
	    md.mat.translate(-(md.xmin + md.xmax) / 2,
			     -(md.ymin + md.ymax) / 2,
			     -(md.zmin + md.zmax) / 2);
	    md.mat.mult(amat);
	    md.mat.scale(xfac, -xfac, 16 * xfac / size().width);
	    md.mat.translate(xoff + size().width / 2, yoff + size().height / 2, 8);
	    md.transformed = false;
	    md.paint(g);
	    setPainted();
	} else if (message != null) {
	    g.drawString("Error in model:", 3, 20);
	    g.drawString(message, 10, 40);
	}
    }
    private synchronized void setPainted() {
	painted = true;
	notifyAll();
    }
//    private synchronized void waitPainted() {
//	while (!painted)
//	    wait();
//	painted = false;
//    }
}
